<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class App extends CI_Controller {

	public function __construct()
    {
        parent::__construct();
 		$this->load->helper('AfricasTalkingGateway');
    }

	public function index()
	{
		$this->load->view('app/index');
	} 
	
	function deposit_types()
	{
	    $types = $this->App_Model->get_deposit_types();
	    echo json_encode($types);
	}
	
	function loan_types()
	{
	    $types = $this->App_Model->get_loan_types();
	    echo json_encode($types);
	}
	
	function charge_types()
	{
	    $types = $this->App_Model->get_charge_types();
	    echo json_encode($types);
	}

	function users()
	{
	    $users = $this->App_Model->get_users();
	    echo json_encode($users);
	}
	
	function members()
	{
	    $members = $this->App_Model->get_members();
	    echo json_encode($members);
	}
	
	function upload_deposits()
	{
		$deposits = $this->input->post('deposits');
		$this->App_Model->upload_deposits($deposits);
	}
	
	function upload_deposit()
	{
		$member = $this->input->post('member');
		$member_name = $this->input->post('member_name');
		$amount = $this->input->post('amount');
		$description = $this->input->post('description');
		$type = $this->input->post('type');
		$staffname = $this->input->post('staffname');
		$staffdate = $this->input->post('staffdate');
		$lat = $this->input->post('lat');
		$lng = $this->input->post('lng');
		$dt = $this->input->post('dt');
		
		if ($amount=='0') {}
		elseif ($member=='') {} 
		else {
			$this->App_Model->upload_deposit($member,$member_name,$amount,$description,$type,$staffname,$staffdate,$lat,$lng,$dt);
			
			$msg = 'Dear '.$member_name.'. Your payment for '.$type.' of Kshs. '.$amount.' has been received. Thanks for being our customer.';
			$no = '703390857';
			$no = '721721376';
			$no = '722320986';
			$no = '716325193';
			$no = trim($no);
			if (strlen($no) == 9) {$no = '0' . $no;}
			if (strlen($no) == 10) {$no = '+254' . $no;}
			$this->txt($no,$msg);
		}
	}
	
	function txt($number,$message)
	{
		$username   = "Teller";
		$apikey = "6f3d0e0c0cf519052c1b04b5cc6cbc00b7bfc6d8802e0bb3e23373e578658156";
		
		$gateway    = new AfricasTalkingGateway($username, $apikey);
		
		$sender = 'HomeBisacco';
		
		try 
		{ 
		  $results = $gateway->sendMessage($number, $message,$sender);
					
		  foreach($results as $result) {
		    echo " Number: " .$result->number;
		    echo " Status: " .$result->status;
		    echo " MessageId: " .$result->messageId;
		    echo " Cost: "   .$result->cost."\n";
		  }
		}
		catch ( AfricasTalkingGatewayException $e )
		{
		  echo "Encountered an error while sending: ".$e->getMessage();
		}    
	}
	
	function verify_login()
	{
		$login = $this->input->post('login');
		$passwd = $this->input->post('passwd');
		
		echo $this->App_Model->verify_login($login,$passwd);
	}


	function gDeposits(){
		$posted = 0;
		//$query = $this->App_Model->gDepo($posted);
		
		echo json_encode($this->App_Model->gDepo($posted));
	}

	function repayments(){
		$module = $this->input->get("module");
		$staff = $this->input->get("loginid");
		
		echo json_encode($this->App_Model->get_repayments($module,$staff));
	}

	function repayments_all(){
		$module = $this->input->get("module");
		$staff = $this->input->get("loginid");
		
		echo json_encode($this->App_Model->get_repayments_all($module,$staff));
	}

	function repayments_total(){
		$module = $this->input->get("module");
		$staff = $this->input->get("loginid");
		
		echo $this->App_Model->get_repayments_total($module,$staff);
	}

	 function gTtal($staffD){
	 	$staffDet = $staffD;
		$val = $this->App_Model->gTotal($staffDet);
		foreach ($val as $row ) {
			$ta = array(
				'totalAmount' => $row->TAmount
			);
			# code...
		}

		$staffAmount = $ta['totalAmount'];
		// echo json_encode($val);
		$posted = 0;
		$re = $this->App_Model->gDepo($posted,$staffDet);
		foreach ($re  as $row ) {
			$Fresponse [] = array(
				'staffname' => $row->staffname,
				'description' => $row->description,
				'staffdate' => $row->staffdate,
				'amount' => $staffAmount,
				'reference' => $row->ref,
				'type' => $row->type
			);
			# code...
		}
		echo json_encode($Fresponse);

	}

	function clients()
	{
		$module = $this->input->get("module");
		$staff = $this->input->get("loginid");
		
		echo json_encode($this->App_Model->get_clients($module,$staff));
	}

	function clients_unapproved()
	{
		$module = $this->input->get("module");
		$staff = $this->input->get("loginid");
		
		echo json_encode($this->App_Model->get_clients_unapproved($module,$staff));
	}

	function client_loan_balance()
	{
		$client = $this->input->get("client");
		$staff = $this->input->get("loginid");
		#$client = 'CL00013';
		echo json_encode($this->App_Model->get_client_loan_balance($client,$staff));
	}

	function repayment_schedule()
	{
		$client = $this->input->get("client");
		$staff = $this->input->get("loginid");
		#$client = 'CL00013';
		echo json_encode($this->App_Model->get_repayment_schedule($client,$staff));
	}

	function loan_repayments()
	{
		$client = $this->input->get("client");
		$staff = $this->input->get("loginid");
		#$client = 'CL00007';
		echo json_encode($this->App_Model->get_loan_repayments($client,$staff));		
	}

	function client_record()
	{
		$name = $this->input->post('name');
		$telephone = $this->input->post('telephone');
		$loginid = $this->input->post('loginid');
		$idNo = '';
		
		echo json_encode($this->App_Model->get_client_record($name,$idNo,$telephone,$loginid));		
	}

	function reminder()
	{
		echo $this->App_Model->add_reminder($this->input->post());	
	}

	public function client_add()
	{
		echo $this->App_Model->client_add($this->input->post());
	}

	public function lead_add()
	{
		echo $this->App_Model->lead_add($this->input->post());
	}

	public function prospects()
	{
		$staff = $this->input->get("loginid");
		
		echo json_encode($this->App_Model->get_prospects($staff));		
	}

	public function prospect_add()
	{
		echo $this->App_Model->prospect_add($this->input->post());
	}

	public function upload()
    {
    	$type = $this->input->post('type');
    	$code = $this->input->post('client');
    	$screate = $this->input->post('loginid');
            	
        $dir = './uploads/app/'.$type;
		if (!file_exists($dir)) {
			mkdir($dir, 0777, true);
		}

        $config['upload_path']          = $dir;
        $config['allowed_types']        = '*';
        $config['max_size']             = 0;
        $config['max_width']            = 0;
        $config['max_height']           = 0;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('uploaded_file'))
        {
            $error = $this->upload->display_errors();
            echo json_encode(array(
                    'file'  => 'upload failed!',
                    'message' => $error,
                    'remarks' => $config['upload_path'],
            ));
        } else {
            $data = array('upload_data' => $this->upload->data());

        	$fname = $this->upload->data('file_name');
        	$ftype = $this->upload->data('file_type');
        	$fext = $this->upload->data('file_ext');
            $fpath = $this->upload->data('full_path');
                        
            $f_id = $this->App_Model->upload_attachment(
            	$code,$type,$fname,$ftype,$fext,$fpath,$screate
            );

       		
    		echo json_encode(array(
                'message' => 'Upload Succeded.',
    		));
		}
    }

    public function set_fcm_token()
    {
    	echo $this->App_Model->update_fcm_token($this->input->post());
    }

    public function activity_log()
    {
    	$this->App_Model->log_activity($this->input->post());	
    }

    public function notify()
    {
        $post['to'] = 'JNTINYARI';
        $post['from'] = 'ADMIN';
        $post['title'] = 'Cyber warfare';
        $post['details'] = 'Stuxnet';

    	$this->App_Model->add_notification($post); //$this->input->post()	
    }

    public function messages()
	{
		$staff = $this->input->get("loginid");
		
		echo json_encode($this->App_Model->get_messages($staff));		
	}

    public function dashboard()
    {
        #$data['dash'] = $this->Index_Model->get_dashboard();
        #$data['pending_actions'] = $this->Index_Model->get_my_pending_actions();
        #$data['activity'] = $this->Index_Model->get_my_activity_log();
        #$data['repayments'] = $this->BorrowersModel->get_my_upcoming_repayments();
        #$data['clients'] = $this->BorrowersModel->get_my_clients();
        
        $staff = $this->input->get('loginid');
        $this->App_Model->audit_trail('Dashboard accessed.',$staff,'DASHBOARD');
		$data = $this->Index_Model->get_dashboard($staff);
        /*foreach ($data as $k=>$v) {
        	$d['key'] = $k;
        	$d['value'] = $v;
        }*/

        echo '['.json_encode($data).']'; 
    }

    public function actors()
    {
    	$staff = $this->input->post('loginid');
        echo json_encode($this->App_Model->get_actors($staff));		
    }

    public function message_send()
    {
    	echo $this->App_Model->add_notification($this->input->post());
    }

}
