<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Expenses extends CI_Controller {


	public function index()
	{

	}

	public function sViewExpenses()
	{
		$this->load->view('expenses/viewexpenses');
	}
	
	public function add_expense()
	{
		$data['expenses'] = $this->Index_Model->get_accounts('EXPENSE');
		$data['accounts'] = $this->Index_Model->get_accounts('ALL');
		$data['officers'] = $this->Index_Model->get_officers_('ALL');
		$data['branches'] = $this->BorrowersModel->getBranches();
		
		$this->load->view('expenses/add_expense',$data);
	}

	public function save_expense()
	{
		echo $this->ExpensesModel->save_expense($this->input->post('expense'));	
	}
	
	public function unposted_expenses()
	{
		$this->load->view('expenses/unposted_expenses');
	}
	
	public function posted_expenses()
	{
		$this->load->view('expenses/posted_expenses');
	}
	
	public function reversed_expenses()
	{
		$this->load->view('expenses/reversed_expenses');
	}

	public function unposted_list_()
	{
		function status($id='')
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue" href="#" id="id_expense_post" ref="'.$id.'">Post</a>
	            </div>
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-red" href="#" id="id_expense_reverse" ref="'.$id.'">Reverse</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->ExpensesModel->get_expenses_($requestData,$totalData,$totalFiltered,0);

		$data = array();
		foreach ($query as $q) {
			$saving = array(); 

			$saving[] = $q->id;
			$saving[] = status($q->id);
			$saving[] = $q->ref;
			$saving[] = $q->expense_acct;
			$saving[] = $q->name;
			$saving[] = date('d/m/y',strtotime($q->edate));
			$saving[] = $q->branch;
			$saving[] = $q->remarks;
			$saving[] = $q->control_acct;
			$saving[] = number_format($q->amount,0);
			$saving[] = $q->status_;
			
			$data[] = $saving;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);
	}

	public function post_expense()
	{
		echo $this->ExpensesModel->post_expense($this->input->post());
	}

	public function reverse_expense()
	{
		echo $this->ExpensesModel->reverse_expense($this->input->post());
	}

	public function posted_list_()
	{
		function status($id='')
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-red" href="#" id="id_expense_reverse" ref="'.$id.'">Reverse</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->ExpensesModel->get_expenses_($requestData,$totalData,$totalFiltered,1);

		$data = array();
		foreach ($query as $q) {
			$saving = array(); 

			$saving[] = $q->id;
			$saving[] = status($q->id);
			$saving[] = $q->ref;
			$saving[] = $q->expense_acct;
			$saving[] = $q->name;
			$saving[] = date('d/m/y',strtotime($q->edate));
			$saving[] = $q->branch;
			$saving[] = $q->remarks;
			$saving[] = $q->control_acct;
			$saving[] = number_format($q->amount,0);
			$saving[] = $q->spost;
			$saving[] = $q->dpost;
			
			$data[] = $saving;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);
	}

	public function reversed_list_()
	{
		$requestData = $_REQUEST;

		$query = $this->ExpensesModel->get_expenses_($requestData,$totalData,$totalFiltered,9);

		$data = array();
		foreach ($query as $q) {
			$saving = array(); 

			$saving[] = $q->id;
			$saving[] = $q->ref;
			$saving[] = $q->expense_acct;
			$saving[] = $q->name;
			$saving[] = date('d/m/y',strtotime($q->edate));
			$saving[] = $q->branch;
			$saving[] = $q->remarks;
			$saving[] = $q->control_acct;
			$saving[] = number_format($q->amount,0);
			$saving[] = $q->sreverse;
			$saving[] = $q->dreverse;
			$saving[] = $q->rremarks;
			
			$data[] = $saving;
			
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);
	}

}


