<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Journals extends CI_Controller {


	public function index()
	{

	}

	public function sViewJournal()
	{
		$this->load->view('journals/viewjournals');
	}
	
	public function add_journal()
	{
		$data['accounts'] = $this->Index_Model->get_accounts('ALL');
		$data['officers'] = $this->Index_Model->get_officers_('ALL');
		$data['branches'] = $this->BorrowersModel->getBranches();
		
		$this->load->view('journals/add_journal',$data);
	}

	public function save_journal()
	{
		echo $this->JournalsModel->save_journal($this->input->post('journal'));	
	} 
	
	public function unposted_journals()
	{
		$this->load->view('journals/unposted_journals');
	}
	
	public function posted_journals()
	{
		$this->load->view('journals/posted_journals');
	}
	
	public function reversed_journals()
	{
		$this->load->view('journals/reversed_journals');
	}

	public function unposted_list_()
	{
		function status($id='')
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue" href="#" id="id_journal_post" ref="'.$id.'">Post</a>
	            </div>
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-red" href="#" id="id_journal_reverse" ref="'.$id.'">Reverse</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->JournalsModel->get_journals_($requestData,$totalData,$totalFiltered,0);

		$data = array();
		foreach ($query as $q) {
			$saving = array(); 

			$saving[] = $q->id;
			$saving[] = status($q->id);
			$saving[] = $q->ref;
			$saving[] = $q->journal_ref;
			$saving[] = $q->debit_acct;
			$saving[] = $q->name;
			$saving[] = date('d/m/y',strtotime($q->jdate));
			$saving[] = $q->branch;
			$saving[] = $q->remarks;
			$saving[] = $q->credit_acct;
			$saving[] = number_format($q->amount,0);
			$saving[] = $q->status_;
			
			$data[] = $saving;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);
	}

	public function post_journal()
	{
		echo $this->JournalsModel->post_journal($this->input->post());
	}

	public function reverse_journal()
	{
		echo $this->JournalsModel->reverse_journal($this->input->post());
	}

	public function posted_list_()
	{
		function status($id='')
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-red" href="#" id="id_journal_reverse" ref="'.$id.'">Reverse</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->JournalsModel->get_journals_($requestData,$totalData,$totalFiltered,1);

		$data = array();
		foreach ($query as $q) {
			$saving = array(); 

			$saving[] = $q->id;
			$saving[] = status($q->id);
			$saving[] = $q->ref;
			$saving[] = $q->journal_ref;
			$saving[] = $q->debit_acct;
			$saving[] = $q->name;
			$saving[] = date('d/m/y',strtotime($q->jdate));
			$saving[] = $q->branch;
			$saving[] = $q->remarks;
			$saving[] = $q->credit_acct;
			$saving[] = number_format($q->amount,0);
			$saving[] = $q->spost;
			$saving[] = $q->dpost;
			
			$data[] = $saving;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);
	}

	public function reversed_list_()
	{
		$requestData = $_REQUEST;

		$query = $this->JournalsModel->get_journals_($requestData,$totalData,$totalFiltered,9);

		$data = array();
		foreach ($query as $q) {
			$saving = array(); 

			$saving[] = $q->id;
			$saving[] = $q->ref;
			$saving[] = $q->journal_ref;
			$saving[] = $q->debit_acct;
			$saving[] = $q->name;
			$saving[] = date('d/m/y',strtotime($q->jdate));
			$saving[] = $q->branch;
			$saving[] = $q->remarks;
			$saving[] = $q->credit_acct;
			$saving[] = number_format($q->amount,0);
			$saving[] = $q->sreverse;
			$saving[] = $q->dreverse;
			$saving[] = $q->rremarks;
			
			$data[] = $saving;
			
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);
	}

}


