<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Login extends CI_Controller {
 
    public function __construct() {
        parent::__construct();
        $this->load->library(array('session', 'form_validation'));
        $this->load->helper(array('url', 'html', 'form'));
        $this->load->model('Index_Model');
    }
	
	public function test() {
		echo '123';
	}
	
    public function index() {
        $data['branches'] = $this->Index_Model->get_branches__(1);
        $this->load->view('login/index',$data);
    }

    public function logmein() {
        $user = $this->input->post('userid');
        $passwd = $this->input->post('password');
        $branch = $this->input->post('branch');
        $location = $branch;
        $company = '';
        if (trim($user) == '') {
            redirect('/login/');
        }

        if (trim($passwd) == '') {
            redirect('/login/');
        }

        if (trim($branch) == '') {
            redirect('/login/');
        }

        $this->auth_user($user, $passwd, $company);
    }

    function auth_user($user, $passwd, $company) {
        $user_known = $this->Index_Model->authenticate_user($user, $passwd, $company);
        if (is_scalar($user_known)) {
			//echo '1';
            redirect('/login/logout');
        } else {
            $this->session->set_userdata('id', trim($user_known->id));
            $this->session->set_userdata('username', trim($user_known->username));
            //$this->session->set_userdata('usercode', trim($user_known->usercode));
            $this->session->set_userdata('usercode', trim($user_known->username));
            $this->session->set_userdata('useremail', trim($user_known->email));
            $this->session->set_userdata('branch', $user_known->branch);
            $this->session->set_userdata('logged_in', '1');
            //$this->session->set_userdata('company', trim($user_known->company));
            $this->session->set_userdata('company', "FRONTIER KENYA CREDIT");
            $this->session->set_userdata('role',strtoupper($user_known->user_role));

            #Rights
            $this->session->set_userdata('user_right', trim(strtoupper($user_known->user_role)));
			//echo '2';
            redirect('/dashboard/');
        }
    }

    function logout() {
        $user = $this->session->userdata('username');
        $this->Index_Model->log_activity(0,$user,'Logged out','');

        $this->session->unset_userdata('id');
        $this->session->unset_userdata('username');
        $this->session->unset_userdata('usercode');
        $this->session->unset_userdata('logged_in');
        $this->session->unset_userdata('office');

        $this->session->unset_userdata('user_right');

        redirect('/login/');
    }

    function password() {
        $data['title'] = 'Change Password';
        $data['subtitle'] = $data['title'];
        $data['subdesc'] = 'Change Password';
         $this->load->view('login/password');
    }

    function password_check() {
        $password = $this->input->post('password');
        $rpassword = $this->input->post('rpassword');

        if ($password != $rpassword) {
            $this->form_validation->set_message('password_check', 'The Password and Repeat Password are not the same!');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    function change_password() {
        $this->form_validation->set_rules('password', 'New Password', 'required');
        $this->form_validation->set_rules('rpassword', 'Password', 'callback_password_check');

        if ($this->form_validation->run() == FALSE) {
            $this->password();
        } else {
            $password = $this->input->post('password');
            $this->load->model('Index_Model');
            $this->Index_Model->change_password($password);
            $this->password_changed();
        }
    }

    function password_changed() {
/*        $data['title'] = 'Password Changed';
        $data['subtitle'] = $data['title'];
        $data['subdesc'] = 'Password Changed';
        $this->load->view('templates/view_header', $data);
        $this->load->view('templates/view_sidebar', $data);
        $this->load->view('templates/view_title');
        $this->load->view('login/password_changed');
*/    }

    function register()
    {
        $this->load->view('login/register');
    }

    function registerme()
    {
/*        $this->form_validation->set_rules('company', 'Company', 'required');
        $this->form_validation->set_rules('contact_person', 'Contact Person', 'required');
        $this->form_validation->set_rules('contact_person', 'Contact Person', 'required');
        $this->form_validation->set_rules('email', 'Email', 'required');
        $this->form_validation->set_rules('mobile', 'Mobile', 'required');

        if ($this->form_validation->run() == FALSE) {
            $this->register();
        } else {
            $company = $this->input->post('company');
            $contact_person = $this->input->post('contact_person');
            $email = $this->input->post('email');
            $mobile = $this->input->post('mobile');

            $pin = $this->Index_Model->register($company,$contact_person,$email,$mobile);

            $this->load->model('Messaging_Model','m');
            $this->m->send_email($email,$company,$company.' Registered to www.parcel.smile.co.ke');
            $this->m->send_sms($company,$mobile,$company.' Registered to www.parcel.smile.co.ke. PIN '.$pin);
            $this->registered();
        }
*/    }

    function registered()
    {
        $this->load->view('login/registered');
    }

    public function update_password() {
        echo $this->Index_Model->update_password($this->input->post('data'));
    }


}
