<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reports extends CI_Controller {


	public function index()
	{

	}

	public function sBorrowersRep()
	{
		$this->load->view('reports/borrowersreport');
	}
	
	public function sCollectionRep()
	{
		$this->load->view('reports/collectionsreport');
	}
	
	public function sCollectorRep(){
		$this->load->view('reports/collectorreport_staff');
	}

	public function sDefferedIncome()
	{
		$this->load->view('reports/deferedincome');
	}

	public function sDisbursementRep()
	{
		$this->load->view('reports/disbursementreport');
	}

	public function sFeesRep()
	{
		$this->load->view('reports/feesreport');
	}

	public function sLoanOfficerRep()
	{
		$this->load->view('reports/loanofficerreport');
	}

	public function sLoanProductRep()
	{
		$this->load->view('reports/loanproductsreport');
	}

    public function sMfrsRatios()
    {
		$this->load->view('reports/mfrsratios');
	}

    public function sPortfolioAtRisk()
    {
		$this->load->view('reports/portfolioatrisk');
	}

    public function sVallentries()
    {
		$this->load->view('reports/allentries');
	}

	public function repayments() 
	{
		$data['products'] = $this->BorrowersModel->getloanTypes();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();

		$this->load->view('reports/repayments',$data);
	}

	public function pdf_repayments_rpt()
	{
		$data['report'] = $this->ReportModel->get_repayments_rpt($this->input->post());
		$data['dateFrom'] = $this->input->post('dateFrom');
		$data['dateTo'] = $this->input->post('dateTo');
		
		$html = $this->load->view('print/repayments_rpt',$data,true);
		$pdfFilePath = "repayments_rpt.pdf";
		$mpdf = new \Mpdf\mPDF(['orientation' => 'L']);
		$mpdf->WriteHTML($html);
		$mpdf->Output();
	}

	public function excel_repayments_rpt()
	{
		$this->load->helper('download');
        $data = $this->ReportModel->get_repayments_excel($this->input->post());
        $name = 'repayments.csv';
        force_download($name,$data);
	}

	public function preview_repayments_rpt()
	{
		$data['report'] = $this->ReportModel->get_repayments_rpt($this->input->post());
		$data['dateFrom'] = $this->input->post('dateFrom');
		$data['dateTo'] = $this->input->post('dateTo');
		
		$this->load->view('print/repayments_rpt',$data);
	}

	public function expected() 
	{
		$data['products'] = $this->BorrowersModel->getloanTypes();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();

		$this->load->view('reports/expected',$data);
	}

	public function pdf_expected_rpt()
	{
		$data['report'] = $this->ReportModel->get_expected_rpt($this->input->post());
		$data['dateFrom'] = $this->input->post('dateFrom');
		$data['dateTo'] = $this->input->post('dateTo');
		
		$html = $this->load->view('print/expected_rpt',$data,true);
		$pdfFilePath = "expected_rpt.pdf";
		$mpdf = new \Mpdf\mPDF(['orientation' => 'L']);
		$mpdf->WriteHTML($html);
		$mpdf->Output();
	}

	public function excel_expected_rpt()
	{
		$this->load->helper('download');
        $data = $this->ReportModel->get_expected_excel($this->input->post());
        $name = 'repayments.csv';
        force_download($name,$data);
	}

	public function preview_expected_rpt()
	{
		$data['report'] = $this->ReportModel->get_expected_rpt($this->input->post());
		$data['dateFrom'] = $this->input->post('dateFrom');
		$data['dateTo'] = $this->input->post('dateTo');
		
		$this->load->view('print/expected_rpt',$data);
	}

	public function par() 
	{
		$data['products'] = $this->BorrowersModel->getloanTypes();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();

		$this->load->view('reports/par',$data);
	}

	public function pdf_par_rpt()
	{
		$data['report'] = $this->ReportModel->get_par_rpt($this->input->post());
		$data['rptDate'] = $this->input->post('rptDate');
		$rptType = $this->input->post('rptType');
		
		if (strtoupper($rptType)=='DETAILED') {
			$html = $this->load->view('print/par_rpt',$data,true);
		} else {
			$html = $this->load->view('print/par_summary_rpt',$data,true);
		}
		$pdfFilePath = "par_rpt.pdf";
		$mpdf = new \Mpdf\mPDF(['orientation' => 'L']);
		$mpdf->WriteHTML($html);
		$mpdf->Output();
	}

	public function excel_par_rpt()
	{
		$this->load->helper('download');
        $data = $this->ReportModel->get_par_excel($this->input->post());
        $name = 'par_rpt.csv';
        force_download($name,$data);
	}

	public function preview_par_rpt()
	{
		$data['report'] = $this->ReportModel->get_par_rpt($this->input->post());
		$data['rptDate'] = $this->input->post('rptDate');
		$rptType = $this->input->post('rptType');
		
		if (strtoupper($rptType)=='DETAILED') {
			$html = $this->load->view('print/par_rpt',$data);
		} else {
			$html = $this->load->view('print/par_summary_rpt',$data);
		}
	}

	public function loan_book()
	{
		$data['products'] = $this->BorrowersModel->getloanTypes();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();

		$this->load->view('reports/loan_book',$data);
	}

	public function pdf_loan_book_rpt()
	{
		$data['report'] = $this->ReportModel->get_loan_book_rpt($this->input->post());
		$data['rptDate'] = $this->input->post('rptDate');
		$rptType = $this->input->post('rptType');
		
		if (strtoupper($rptType)=='DETAILED') {
			$html = $this->load->view('print/loan_book_rpt',$data,true);
		} else {
			$html = $this->load->view('print/loan_book_summary_rpt',$data,true);
		}
		$pdfFilePath = "loan_book_rpt.pdf";
		$mpdf = new \Mpdf\mPDF(['orientation' => 'L']);
		$mpdf->WriteHTML($html);
		$mpdf->Output();
	}

	public function excel_loan_book_rpt()
	{
		$this->load->helper('download');
        $data = $this->ReportModel->get_loan_book_excel($this->input->post());
        $name = 'loan_book_rpt.csv';
        force_download($name,$data);
	}

	public function preview_loan_book_rpt()
	{
		$data['report'] = $this->ReportModel->get_loan_book_rpt($this->input->post());
		$data['rptDate'] = $this->input->post('rptDate');
		$rptType = $this->input->post('rptType');
		
		if (strtoupper($rptType)=='DETAILED') {
			$html = $this->load->view('print/loan_book_rpt',$data);
		} else {
			$html = $this->load->view('print/loan_book_summary_rpt',$data);
		}
	}


}