<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Savings extends CI_Controller {


	public function index()
	{
	}

	public function sSavingsAcc()
	{
		$this->load->view('savings/viewsavingsacc');
	}
	
	public function sAddSavings()
	{
		$data['loanTypes'] = $this->BorrowersModel->getloanTypes();
		$data['clients'] = $this->BorrowersModel->getClients_();
		$data['loan_officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['savingType'] = $this->BorrowersModel->getsavingTypes();

		$this->load->view('savings/addsaving',$data);
	}
	
	public function add_saving_receipt()
	{
		echo $this->SavingsModel->add_saving_receipt($this->input->post('saving'));
	}

	public function sAddSavingsAcc()
	{
		$this->load->view('savings/addsavingsacc');
	}

	public function sAddBulkTrans()
	{
		$this->load->view('savings/addbulktrans');
	}

	public function sViewSavingsTrans()
	{
		$this->load->view('savings/viewsavingstrans');
	}

	public function sSavingsCharts()
	{
		$this->load->view('savings/savingscharts');
	}

    public function sSavingsReport()
    {
		$this->load->view('savings/savingsreport');
	}
	
    public function saving_posted()
    {
		$this->load->view('savings/saving_posted');
	}

    public function saving_reversed()
    {
		$this->load->view('savings/saving_reversed');
	}

	public function savings_unposted_list_()
	{
		function status($id='')
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue" href="#" id="id_client_saving_post" ref="'.$id.'">Post</a>
	            </div>
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-red" href="#" id="id_client_saving_reverse" ref="'.$id.'">Reverse</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->SavingsModel->get_savings_($requestData,$totalData,$totalFiltered,0);

		$data = array();
		foreach ($query as $q) {
			$saving = array(); 

			$saving[] = $q->id;
			$saving[] = status($q->id);
			$saving[] = $q->ref;
			$saving[] = $q->name;
			$saving[] = $q->stype;
			$saving[] = date('d/m/y',strtotime($q->sdate));
			$saving[] = $q->tran_type;
			$saving[] = $q->tran_ref;
			$saving[] = number_format($q->amount,0);
			$saving[] = number_format($q->balance,0);
			$saving[] = $q->status_;
			
			$data[] = $saving;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);
	}

	public function savings_posted_list_()
	{
		function status($id='')
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-red" href="#" id="id_client_saving_reverse_posted" ref="'.$id.'">Reverse</a>
	            </div>
            ';
            
			return $str;
		}
		$requestData = $_REQUEST;

		$query = $this->SavingsModel->get_savings_($requestData,$totalData,$totalFiltered,1);

		$data = array();
		foreach ($query as $q) {
			$saving = array(); 

			$saving[] = $q->id;
			$saving[] = status($q->id);
			$saving[] = $q->ref;
			$saving[] = $q->name;
			$saving[] = $q->stype;
			$saving[] = date('d/m/y',strtotime($q->sdate));
			$saving[] = $q->tran_type;
			$saving[] = $q->tran_ref;
			$saving[] = number_format($q->amount,0);
			$saving[] = number_format($q->balance,0);
			$saving[] = $q->status_;
			$saving[] = $q->spost;
			$saving[] = $q->dpost;
			
			$data[] = $saving;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);
	}

	public function savings_reversed_list_()
	{
		$requestData = $_REQUEST;

		$query = $this->SavingsModel->get_savings_($requestData,$totalData,$totalFiltered,9);

		$data = array();
		foreach ($query as $q) {
			$saving = array(); 

			$saving[] = $q->id;
			$saving[] = $q->ref;
			$saving[] = $q->name;
			$saving[] = $q->stype;
			$saving[] = date('d/m/y',strtotime($q->sdate));
			$saving[] = $q->tran_type;
			$saving[] = $q->tran_ref;
			$saving[] = number_format($q->amount,0);
			$saving[] = number_format($q->balance,0);
			$saving[] = $q->sreverse;
			$saving[] = $q->dreverse;
			$saving[] = $q->rremarks;
			
			$data[] = $saving;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);
	}


	public function post_saving_receipt()
	{
		echo $this->SavingsModel->post_saving_receipt($this->input->post());
	}

	public function reverse_saving_receipt()
	{
		echo $this->SavingsModel->reverse_saving_receipt($this->input->post());
	}
	
}






