<?php

class App_Model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('Firebase');
    }

    function get_deposit_types() 
    {
        return $this->db->query("select * from share_types order by code")->result();   
    }
     
    function get_loan_types()
    {
        return $this->db->query("select * from loan_types order by code")->result();     
    }
    
    function get_charge_types()
    {
        return $this->db->query("select * from charges_fees order by code")->result();     
    }

    function get_users()
    {
        return $this->db->query("select * from login order by code")->result();         
    }
    
    function get_members()
    {
        return $this->db->query("select code,description,tel,mem_idno,status,memgrp,mid from members order by code")->result();    
    }
    
    function upload_deposits($deposits)
    {
        $deposits = json_decode($deposits);
        foreach ($deposits as $d) {
            foreach ($d as $dd) {
                $member = $dd->member;
                $member_name = $dd->member_name;
                $amount = $dd->amount;
                $description = $dd->description;
                $staffname = $dd->staffname;
                $staffdate = $dd->staffdate;
                $lat = $dd->lat;
                $lng = $dd->lng;
                $dt = $dd->dt;
                
				$q = 'select get_next_number("RECEIPT",1) no';
				$code = $this->db->query($q)->row()->no;
				
				$cashaccount = 'A006-001';
				
                $q = "select * from receipts where tcat = '$member' and staffdate = '$staffdate' and amount = '$amount' ";
                if ($this->db->query($q)->num_rows() < 1) {
                    $q = "insert into receipts(code,tcat,tname,cashaccount,trandate,amount,description,staffname,staffdate,type,ref,posted,lat,lng) ".
                          "values('$code','$member','$member_name','$cashaccount',now(),'$amount','$description','$staffname','$staffdate','Client','',0,'$lat','$lng')";
                    $this->db->query($q);
                }
            }
        }
    }
     
	function upload_deposit($member,$member_name,$amount,$description,$type,$staffname,$staffdate,$lat,$lng,$dt)
	{
		$q = 'select get_next_number("RECEIPT",1) no';
		$code = $this->db->query($q)->row()->no;
		
		$cashaccount = 'A006-001';
		
		$q = "select * from receipts where tcat = '$member' and staffdate = '$staffdate' and amount = '$amount' ";
		if ($this->db->query($q)->num_rows() < 1) {
			$q = "insert into receipts(code,tcat,tname,cashaccount,trandate,amount,description,staffname,staffdate,type,ref,posted,lat,lng) ".
				  "values('$code','$member','$member_name','$cashaccount',now(),'$amount','$description','$staffname','$staffdate','Client','$type',0,'$lat','$lng')";
			$this->db->query($q);
		}	
	}
	
    function get_deposit_types_($requestData,&$totalData,&$totalFiltered) 
    {
        $table = 'share_types';

        $columns = array( 
            0 =>'code', 
            1 => 'description',
            2=> 'stid'
        );

        $sql = "SELECT ".$columns[0].", ".$columns[1].", ".$columns[2]." FROM ".$table." where 1 ";
        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ) ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $query = $this->db->query($sql);

        return $query->result();
    }

    function get_loan_types_($requestData,&$totalData,&$totalFiltered) 
    {
        $table = 'loan_types';

        $columns = array( 
            0 =>'code', 
            1 => 'description',
            2=> 'ltid'
        );

        $sql = "SELECT ".$columns[0].", ".$columns[1].", ".$columns[2]." FROM ".$table." where 1 ";
        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ) ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $query = $this->db->query($sql);

        return $query->result();
    }
	
	function get_charge_types_($requestData,&$totalData,&$totalFiltered) 
    {
        $table = 'charges_fees';

        $columns = array( 
            0 =>'code', 
            1 => 'description',
            2=> 'cid'
        );

        $sql = "SELECT ".$columns[0].", ".$columns[1].", ".$columns[2]." FROM ".$table." where 1 ";
        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ) ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $query = $this->db->query($sql);

        return $query->result();
    }
	
	function get_members_($requestData,&$totalData,&$totalFiltered) 
    {
        $table = 'members';

        $columns = array( 
            0 => 'code', 
            1 => 'description',
            2 => 'tel',
			3 => 'mem_idno',
			4 => 'status',
			5 => 'memgrp',
			6 => 'mid'
        );

        $sql = "SELECT ".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".$columns[5].", ".$columns[6]." FROM ".$table." where 1 ";
        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
			$sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $query = $this->db->query($sql);
 
        return $query->result();
    }
    function gDepo($posted,$staffDet){
        $this->db->select('*');
        // $this->db->select ('amount') ;
        // $this->db->group_by('staffname');
        $this->db->where('posted',$posted);
        $this->db->where('staffname',$staffDet);
       // $this->db->where('staffname',0001);
        $this->db->limit(1);
        $res = $this->db->get('receipts');
        return $res->result();
    }
    function gTotal($staffDet){
        $sql = "SELECT SUM(amount) AS 'TAmount' FROM receipts WHERE staffname = $staffDet";

        $tamount = $this->db->query($sql);
        return $tamount->result();
    }

	
	function get_deposits_($requestData,&$totalData,&$totalFiltered,$posted=0) 
    {
        $table = 'receipts';

        $columns = array( 
            0 => 'tcat', 
            1 => 'tname',
            2 => 'amount',
			3 => 'code',
			4 => 'trandate',
			5 => 'description',
			6 => 'staffname',
			7 => 'staffdate',
			8 => 'rid'
        );

        $sql = "SELECT ".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8]." FROM ".$table." where posted = '$posted' ";
        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
			$sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.=" ORDER BY rid desc   
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $query = $this->db->query($sql);

        return $query->result();
    }
		
	function get_tellers_($requestData,&$totalData,&$totalFiltered) 
    {
        $table = 'mobile_users';

        $columns = array( 
            0 => 'code', 
            1 => 'description',
            2 => 'active',
			3 => 'u_right',
			4 => 'device',
			5 => 'telephone',
			6 => 'id'
        );

        $sql = "SELECT ".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".$columns[5].", ".$columns[6]." FROM ".$table." where 1 ";
        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
			$sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $query = $this->db->query($sql);

        return $query->result();
    }
	
	function save_teller($code,$name,$active,$u_right,$passwd,$telephone,$device)
	{
        $q = "select * from mobile_users where code = '$code' ";
        if ($this->db->query($q)->num_rows() < 1) {
            $q = "
					insert into mobile_users(code,description,active,u_right,passwd,device,telephone) 
					values ('$code','$name','$active','$u_right','$passwd','$device','$telephone')";
            $this->db->query($q);
            return 'Teller Account Added.';
        } else {
            $q = "
				update mobile_users set description='$name',active='$active',u_right='$u_right',passwd='$passwd',device='$device',telephone='$telephone' 
				where code='$code' 
			";
            $this->db->query($q);
            return 'Teller Account Updated.';
        }
	}
	
	function get_deposit_type_name_json()
    {
        $q = "select code from share_types order by code";
        $names = $this->db->query($q)->result();
        return json_encode($names);
    }

    function get_loan_type_name_json()
    {
        $q = "select code from loan_types order by code";
        $names = $this->db->query($q)->result();
        return json_encode($names);
    }

    function save_member($code,$name,$telephone,$id)
    {
        $q = "select * from members where code = '$code' ";
        if ($this->db->query($q)->num_rows() < 1) {
            $q = "insert into members(code,description,tel,mem_idno) values ('$code','$name','$telephone','$id')";
            $this->db->query($q);
            return 'Member Account Added.';
        } else {
            $q = "update members set description='$name',tel='$telephone',mem_idno='$id' where code='$code' ";
            $this->db->query($q);
            return 'Member Account Updated.';
        }		
    }
	
	function verify_login($login,$passwd)
	{
		#$q = "select * from mobile_users where code = '$login' and passwd = '$passwd' ";
        $q = "select * from actors where (username = '$login' or email = '$login') and passwd = md5('$passwd') ";
		
        if ($this->db->query($q)->num_rows() < 1) {

            $operation = $login.' failed to login! '.$passwd;
            $this->audit_trail($operation,$login,'LOGIN FAILED');

			return '0';
		} else {
            $operation = $login.' successfully logged in! '.$passwd;
            $this->audit_trail($operation,$login,'LOGIN SUCCESSFULL');

            $q = "update actors set last_login = now() where username = '$login' ";
            $this->db->query($q);


			return '1';
		}
	}
	
	function verify($login,$passwd)
	{
		$q = "select * from users where usercode = '$login' and password = md5('$passwd') and active = 1 ";
		if ($this->db->query($q)->num_rows() < 1) {

            $operation = $login.' failed to login! '.$passwd;
            $this->audit_trail($operation,$login,'LOGIN FAILED');

			return '00';
		} else {
            $operation = $login.' successfully logged in! '.$passwd;
            $this->audit_trail($operation,$login,'LOGIN SUCCESSFULL');

			return '1';
		}
	}

    function audit_trail($operation,$user='',$type='APP')
    {
        if ($user == '') {
            $user = $this->session->userdata('username');
        }

        $q = "call do_audit_trail(?,?,?)";

        $data = array(
            'operation' => $operation,
            'staff' => $user,
            'host' => $this->input->ip_address(),
        );

        $this->db->query($q,$data);

        $q = "call do_log_activity('3','$user','$type','$operation','$user','$user')";  
        $this->db->query($q);

    }

    function get_repayments($module='',$staff='')
    {
        $module = str_replace(' ', '', $module);

        $q = '    
            select concat(c.firstname," ",c.middlename," ",c.lastname)name ,
            c.mobile telephone,date_format(a.repayment_date,"%d/%b/%y")rdate,
            a.principal amount,id_number idno
            from loan_repayment_schedule a,appliedloans b,clients c  
            where a.loanref=b.loan_ref and b.applicant=c.code 
            and (a.repayment-a.prin_paid) > 0
        ';
        
        if ($staff!='APP') $q .= ' and ucase(b.loan_officer) = ucase("'.$staff.'") ';
        
        if ($module == 'T') {
            //$q .= ' and current_date = repayment_date ';
              $d = new DateTime("now", new DateTimeZone("Africa/Nairobi"));
              $current_date = substr($d->format(DateTime::W3C),0,10);
              $q .= ' and repayment_date = "'.$current_date.'" '; 
            $remarks = 'Today Repayments retrieved.';
        } elseif ($module == 'U') {
            $q .= 'and repayment_date between date_add(current_date,interval 1 day) and date_add(current_date,interval 4 day) order by repayment_date';
            $remarks = 'Upcoming Repayments retrieved.';
        } elseif ($module == 'A') {
            $q .= ' and current_date > repayment_date ';
            $remarks = 'Arrears Repayments retrieved.';
        } else {
            $q .= ' and current_date = repayment_date  order by 1';
            $remarks = 'Today Repayments retrieved.';
        }

        if ($module == 'A') {
            $q = 'select concat(c.firstname," ",c.middlename," ",c.lastname)name ,
            c.mobile telephone,date_format(min(a.repayment_date),"%d/%b/%y")rdate,
            sum(a.repayment-a.prin_paid) amount,id_number idno
            from loan_repayment_schedule a,appliedloans b,clients c  
            where a.loanref=b.loan_ref and b.applicant=c.code 
            and (a.repayment-a.prin_paid) > 0
            and current_date > repayment_date
            and ucase(b.status) in ("ACTIVE","ARREARS") and ucase(b.loan_officer) = ucase("'.$staff.'")
            group by 1 order by repayment_date';
        }

        /*$q .= '
            order by 1 limit 100
        ';*/


        $this->audit_trail($remarks,$staff,'APP');

        return $this->db->query($q)->result();
    }

    function get_repayments_all($module='',$staff='')
    {
        $module = str_replace(' ', '', $module);

        $q = '    
            select concat(c.firstname," ",c.middlename," ",c.lastname)name ,
            c.mobile telephone,date_format(a.repayment_date,"%d/%b/%y")rdate,
            a.principal amount,if(repayment_date<current_date,"A",if(repayment_date=current_date,"T","U"))status,id_number idno
            from loan_repayment_schedule a,appliedloans b,clients c  
            where a.loanref=b.loan_ref and b.applicant=c.code 
            and (a.repayment-a.prin_paid) > 0
        ';

        $q .= '
            order by repayment_date limit 200
        ';

        $this->audit_trail('Repayments',$staff,'APP');

        return $this->db->query($q)->result();
    }

    function get_repayments_total($module='',$staff='')
    {
        $q = '    
            select ifnull(sum(a.principal),0) amount
            from loan_repayment_schedule a,appliedloans b,clients c  
            where a.loanref=b.loan_ref and b.applicant=c.code 
                and current_date = repayment_date
                and (a.repayment-a.prin_paid) > 0
        ';

        $this->audit_trail('Repayments Total',$staff,'APP');
        
        return $this->db->query($q)->row()->amount;
    }

    function get_clients($module='',$staff='')
    {
        $module = str_replace(' ', '', $module);

        $q = '    
            select code,name,loan_officer,branch,title,bod_date,id_number,mobile,
            spouse,spouse_mobile,residence,guarantor,guarantor_id,guarantor_mobile 
            from vw_clients where 1
        ';

        if ($staff!='APP') $q .= ' and ucase(loan_officer) = ucase("'.$staff.'") ';

        $q .= '
            order by 2 limit 500
        ';

        $this->audit_trail('Clients retrival',$staff,'APP');

        return $this->db->query($q)->result();
    }

    function get_clients_unapproved($module='',$staff='')
    {
        $module = str_replace(' ', '', $module);

        $q = '    
            select code,name,loan_officer,branch,title,bod_date,id_number,mobile,
            spouse,spouse_mobile,residence,guarantor,guarantor_id,guarantor_mobile 
            from clients_u where 1
        ';

        if ($staff!='APP') $q .= ' and ucase(loan_officer) = ucase("'.$staff.'") ';

        $q .= '
            order by 2 limit 500
        ';

        $this->audit_trail('Unapproved Clients',$staff,'APP');

        return $this->db->query($q)->result();
    }

    function get_client_loan_balance($client='',$staff)
    {
        $q = "
            select format(ifnull(sum(amount),0),0)amount,format(ifnull(sum(paid),0),0)paid,format(ifnull(sum(amount),0)-ifnull(sum(paid),0),0) balance,ifnull(status,'?')status
                ,ifnull(DATE_FORMAT(date_applied, '%b %d %Y'),'')date_applied
            from vw_appliedloans 
            where applicant = '$client'
        ";

        $client = $this->db->query("select name from vw_clients where code = '$client' ")->row()->name;

        $this->audit_trail('Client '.$client.' Loans Balance Viewed ',$staff,'APP');

        return $this->db->query($q)->result();
    }

    function get_repayment_schedule($client='',$staff='SYSTEM')
    {
        $q = "
            select c.status, loantype,principal,DATE_FORMAT(repayment_date, '%b %d %Y') rdate,prin_paid paid,
            concat(b.firstname,' ',b.middlename,' ',b.lastname)name
            from loan_repayment_schedule a,clients b,appliedloans c  
            where a.mno = '$client' and a.mno=b.code 
            and a.loanref=c.loan_ref and c.status in ('Active','Arrears')
        ";

        $client = $this->db->query("select name from vw_clients where code = '$client' ")->row()->name;
        
        $this->audit_trail('Client '.$client.' Loans Repayment Schedule Viewed ',$staff,'APP');

        return $this->db->query($q)->result();
    }

    function get_loan_repayments($client='',$staff='SYSTEM')
    {
        $q = "
            select ref,DATE_FORMAT(pdate, '%b %d %Y') pdate,
            DATE_FORMAT(dt, '%b %d %Y') dt,
            amount,
            balance,remarks,spost,dpost,tran_type,tran_ref
            from repayments where code = '$client'
        ";

        $client = $this->db->query("select name from vw_clients where code = '$client' ")->row()->name;
        
        $this->audit_trail('Client '.$client.' Loans Repayments Viewed ',$staff,'APP');

        return $this->db->query($q)->result();
    }

    function get_client_record($name,$idNo,$telephone,$loginid='SYSTEM')
    {
        $this->audit_trail('Client '.$name.' record viewed.',$loginid,'CLIENT');

        $q = "
            select code,name,loan_officer,branch,title,bod_date,id_number,mobile,
            spouse,spouse_mobile,residence,guarantor,guarantor_id,guarantor_mobile 
            from vw_clients where name = '$name'
        ";
        return $this->db->query($q)->result();
    }

    function add_reminder($reminder)
    {
        $c_name = $reminder['client'];

        $c_code = $this->db->query("select code from vw_clients where name = '$c_name'")->row()->code;
        
        $c_tel = $reminder['tel'];
        $r_date = $reminder['date'];
        $r_time = $reminder['time'];
        $r_details = $reminder['details'];
        $r_action = $reminder['action'];
        $screate = $reminder['loginid'];
        
        $q = "
            insert into reminders(c_code,c_name,c_tel,r_date,r_time,r_details,r_action,dt,screate)
            values('$c_code','$c_name','$c_tel','$r_date','$r_time','$r_details','$r_action',now(),'$screate')
        ";

        $this->db->query($q);

        $this->audit_trail(' Reminder '.$name.' Added '.$r_details,$screate,'REMINDER');  
    }

    function client_add($client)
    {
        $name = $client['name'];
        $idno = $client['idno'];
        $mobile = $client['mobile'];
        $address = $client['address'];
        $marital = $client['marital'];
        $children = $client['children'];
        $guarantor = $client['guarantor'];
        $guarantor_mobile = $client['guarantor_mobile'];
        $guarantor_id = $client['guarantor_id'];
        $spouse = $client['spouse'];
        $spouse_mobile = $client['spouse_mobile'];
        $spouse_id = $client['spouse_id'];
        $category = $client['category'];
        $loan_officer = $client['loan_officer'];
        $branch = $client['branch'];
        
        $screate = '';
        
        $exists = $this->db->query("select count(1) c from clients_u where name = '$name' ")->row()->c;

        if ($exists > 0) {
            return $name.' ALREADY EXISTS!';
        } else {
            $code = $this->db->query("select get_next_number('CLIENTUNAPPROVED',1)code")->row()->code;
            
            
            $q = "
                insert into clients_u(
                    code,name,id_number,mobile,address,marital,children,guarantor,
                    guarantor_id,guarantor_mobile,spouse,spouse_id,spouse_mobile,category,dt,
                    screate,loan_officer,branch,bod_date
                ) values (
                    '$code','$name','$idno','$mobile','$address','$marital','$children','$guarantor','$guarantor_id','$guarantor_mobile','$spouse','$spouse_id','$spouse_mobile','$category',now(),'$screate','$loan_officer','$branch',now()
                )
            ";
            
            $this->db->query($q);
            
            $this->audit_trail(
                ' Client '.$name.' Added for approval'.$r_details,$screate,'CLIENT'
            );

            return $name.' registered with a temporary account '.$code;
        }
    }

    function lead_add($lead)
    {
        $name = $lead['name'];
        $idno = $lead['idno'];
        $mobile = $lead['mobile'];
        $address = $lead['address'];
        $marital = $lead['marital'];
        $children = $lead['children'];
        $details = $lead['details'];
        $followup_date = $lead['followup_date'];
        $followup_type = $lead['followup_type'];
        $category = $lead['category'];  
        $loan_officer = $lead['loan_officer'];
        $branch = $lead['branch'];
        $title = $lead['title'];
        $screate = $lead['loginid'];
        
        $exists = $this->db->query("select count(1) c from leads where name = '$name' ")->row()->c;

        if ($exists > 0) {
            return $name.' ALREADY EXISTS!';
        } else {
            $code = $this->db->query("select get_next_number('LEAD',1)code")->row()->code;
            
            
            $q = "
                insert into leads(
                    code,name,id_number,mobile,address,marital,children,details,followup_date,
                    followup_type,category,dt,screate,loan_officer,branch,title
                ) values (
                    '$code','$name','$idno','$mobile','$address','$marital','$children',
                    '$details','$followup_date','$followup_type','$category',now(),
                    '$screate','$loan_officer','$branch','$title'
                )
            ";
            
            $this->db->query($q);
            
            $this->audit_trail(
                ' Prospect '.$name.' Added'.$mobile,$screate,'PROSPECT'
            );

            return $name.' registered with account '.$code;
        }
    }

    function get_prospects($staff)
    {
        $q = "select * from leads order by name";

        return $this->db->query($q)->result();
    }

    function prospect_add($prospect)
    {
        return $this->lead_add($prospect);   
    }

    function upload_attachment($code,$type,$fname='',$ftype='',$fext='',$fpath='',$screate='')
    {
        $cid = '0';

        $q = "
            insert into attachments(cid,ccode,fname,ftype,f_type,fext,fpath,screate,dcreate)
            values('$cid','$code','$fname','$type','$ftype','$fext','$fpath','$screate',now())
        ";

        $this->db->query($q);

        $this->audit_trail(
                ' Attachment '.$type.' of '.$fname.' Added',$screate,'ATTACHMENT'
        );
    }   

    function update_fcm_token($fcm_token)
    {
        $id = $fcm_token['loginid'];
        $token = $fcm_token['token'];

        $q = " call do_fcm_token('$id','$token')";
        $this->db->query($q);

        $this->audit_trail('FCM Token Updated',$id,'NOTIFICATION');
    }

    function get_fcm_token($id)
    {
        $q = "select fcm_token from actors  where ucase(username)=ucase('$id') or ucase(email)=ucase('$id') ";
        return $this->db->query($q)->row()->fcm_token;
    }

    function log_activity($log)
    {
        $logx = $log['log'];
        $loginid = $log['loginid'];
        $type = $log['type'];

        $this->audit_trail($logx,$loginid,$type);
    }


    function add_notification($notify)
    {
        $n_to = $notify['to'];
        $n_from = $notify['loginid'];
        $title = $notify['title'];
        $details = $notify['details'];
    
        $q = "
            insert into notifications(n_to,n_from,title,details,dt) 
            values('$n_to','$n_from','$title','$details',now())
        ";

        $this->db->query($q);

        $this->notify($n_to,$title,$details);

        $log = 'Notification from '.$n_from.' to '.$n_to.' '.$title;

        $this->audit_trail($log,$n_from,'NOTIFICATION');
    }

    function notify($id='',$title='',$message='')
    {
        $token = '';

        if ($id == ''){
            $id = 'admin';
        }

        $token = $this->get_fcm_token($id);
            
        if ($title == ''){
            $title = 'New Year Wishes';
        }

        if ($message == ''){
            $message = 'Wishing you a phosphorus YEAR 2018.';
        }

        $devicetoken [] = $token;

        $res = array();

        $res['notification']['title'] = $title;
        $res['notification']['message'] = $message;
        $res['notification']['image'] = base_url()."assets/images/logo1.png";

        $res['data']['title'] = $title;
        $res['data']['message'] = $message;
        $res['data']['image'] = base_url()."assets/images/logo1.png";

        $firebase = new Firebase(); 

        echo $firebase->send($devicetoken, $res);
    }

    function get_messages($staff='')
    {
        $q = "select * from notifications where (n_to = '$staff' or n_from = '$staff') order by 1 desc";

        #$q = "select * from notifications order by 1 desc";

        $this->audit_trail('Messages retrieved',$staff,'MESSAGES');

        return $this->db->query($q)->result();
    }


    function get_actors($staff='')
    {
        $q = "select username name from actors where username <> '$staff' and status = 1 order by 1";

         return $this->db->query($q)->result();
    }

}

?>