<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class BorrowersModel extends CI_Model {

	function get_borrowers_($requestData,&$totalData,&$totalFiltered,$active=1) 
    {  
        $table = 'vw_clients';

        $columns = array( 
            0 => 'id', 
            1 => 'code',
            2 => 'firstname',
            3 => 'branch',
            4 => 'loan_officer',
            5 => 'bod_date', 
            6 => 'mobile',
            7 => 'status',
            8 => 'id',
            9 => 'middlename',
            10 => 'lastname',
            11 => 'id_number',
            12 => 'guarantor',
            13 => 'guarantor_id',
            14 => 'name',
        );

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", ".$columns[10].", ".$columns[11].
            ", ".$columns[12].", ".$columns[13].", ".$columns[14].
        " FROM ".$table." where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }
 
        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHADMIN') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $status = $requestData['status'];        
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {
            if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";
        }

        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $status = $requestData['status'];  

        if (isset($active)) {
            if($active == "1") {
                $sql .= " and active = 1 ";
            } else {
                $sql .= " and active = 0 ";
            }
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[11]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[12]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[13]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[14]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();
    } 

    function get_borrowers_pending__($requestData,&$totalData,&$totalFiltered) 
    { 
        $table = 'clients_u';

        $columns = array( 
            0 => 'id', 
            1 => 'code',
            2 => 'name',
            3 => 'branch',
            4 => 'loan_officer',
            5 => 'bod_date', 
            6 => 'mobile',
            7 => 'status',
            8 => 'id',
            9 => 'name',
            10 => 'name',
            11 => 'id_number',
            12 => 'guarantor',
            13 => 'guarantor_id',
            14 => 'name',
        );

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", ".$columns[10].", ".$columns[11].
            ", ".$columns[12].", ".$columns[13].", ".$columns[14].
        " FROM ".$table." where 1 ";

        if ($this->session->userdata('role') != 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHADMIN') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $status = $requestData['status'];        
        if (isset($status)) {if($status != "") $sql .= " and gender = '$status' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[12]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[13]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[14]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();
    } 

    function insert_borrower($table,$bidnumber,$borrower){
        $this->db->select('*');
        $this->db->where('id_number',$bidnumber);
         $this->db->from($table);
        $query = $this->db->get();
        if($query->num_rows() > 0){
            $r = "ID already in use!";
            return $r;
        }else
        {
          $this->db->insert("$table",$borrower);
          $r = "Customer Added";
          return $r;
        }
    }

    function update_borrower($table,$code,$borrower){
        $this->db->where('code', $code);
        $this->db->update("$table",$borrower);
        $r = "Customer Updated!";
        return $r;
    }

    function get_borrowers_id(){
        $this->db->select('code');
        $query=$this->db->get('clients');
        $result=$query->result_array();
        return $result;
    }

    function get_name($lborrower_id){
        $this->db->select('description');
        $this->db->where('code',$lborrower_id);
        $rname = $this->db->get('clients');
        return $rname->result();
    }

    function insert_loan($table,$addloan){
        $this->db->insert("$table",$addloan);
        $re = "Loan added successfully";
        return $re;
    }


    function get_loans_($requestData,&$totalData,&$totalFiltered,&$total_loans) 
    { 
        $table = 'vw_appliedloans';

        $columns = array( 
            0 => 'id', 
            1 => 'loan_ref',
            2 => 'applicant',
            3 => 'applicant_name',
            4 => 'branch',
            5 => 'loan_officer',
            6 => 'loan_type',
            7 => 'amount',
            8 => 'date_applied',
            9 => 'status',
            10 => 'id',
            11 => 'applicant_id',
        );

        $sql = "select ifnull(sum(amount),0) total from $table where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHADMIN') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }
        $total_loans = $this->db->query($sql)->row()->total;

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", ".$columns[10].", ".$columns[11]." FROM ".$table." where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHADMIN') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[11]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.= " ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();

    }

    function getloanTypes()
    {
        return $this->db->query("select code,name from loantypes order by 2")->result();
    }

    function getloanTypes_()
    {
        $q = "select code,name from loantypes order by 2";
        $query = $this->db->query($q)->result();
        $data=array();
        foreach ($query as $row) {
            $data[$row->code] = $row->name;
        }
        return $data;
    }

    function getsavingTypes()
    {
        return $this->db->query("select code,description name from deposittypes order by 2")->result();
    }

    function getClients_()
    {
        $q = 'select code,concat(firstname," ",middlename," ",lastname)name from clients order by 2';
        return $this->db->query($q)->result();
    }

    function get_guarator($code) 
    {
        return $this->db->query("select * from guarantors where code = '$code'")->row();
    }

    function getBranches()
    {
        $q = 'select code,description name from branches order by 2';
        return $this->db->query($q)->result();
    }

    function getLoanOfficers()
    {
        $q = 'select username code,fullname name from actors where role = "loanOfficer" order by 2';
        return $this->db->query($q)->result();
    }

    function get_loan_status()
    {
        $q = 'select distinct status from loan_status order by id';
        return $this->db->query($q)->result();
    }

    function getClientDetails($client='')
    { 
        $q = "select a.*,b.amount loan_amt from clients a left join appliedloans b on a.code=b.applicant where code = '$client' limit 1";
        return $this->db->query($q)->result();
    }

    function get_borrower_id_from_loan_ref($loan_ref='')
    { 
        $q = "select id_number from vw_clients_loans a where loan_ref = '$loan_ref' limit 1";
        return $this->db->query($q)->row()->id_number;
    }

    function getClientDetails_ID($id_number='')
    {   
        $q = "select a.* from vw_clients_loans a where id_number = '$id_number' limit 1"; #and balance > 0 
        $query = $this->db->query($q);
        if ($query->num_rows() > 0) {
            return $query->result(); 
        } else {
            $q = "select a.* from vw_clients_loans a where id_number = '$id_number' order by balance desc limit 1";
            return $query->result(); 
        }
    }

    function getLoanType($loan_type='')
    {
        $q = "select * from loantypes where code = '$loan_type' limit 1";
        return $this->db->query($q)->result();
    }

    function getLoanInstallment($loan_type,$loan_amount,$borrower,$installments=1,$int_type='X')
    {        
        $q = " call do_loanInstallment('$loan_type','$loan_amount','$borrower','$int_type','$installments') ";
        $this->db->query($q);

        $q = "select * from tmp_getLoanInstallment limit 1";
        return $this->db->query($q)->result();

//        $arr = array('repayt'=>903,'disbursement'=>398293,'deposit_required'=>13,'deposit_paid'=>45,'processing_fee'=>433);

    }

    function new_loan($loan)
    {
        $data = array();
        $data['loan_officer'] = $loan['loan_officer'];
        $data['branch'] = $loan['branch'];
        $data['loan_type'] = $loan['loan_type'];
        $data['borrower'] = $loan['borrower'];
        $data['loan_date'] = $loan['loan_date'];
        $data['loan_amount'] = $loan['loan_amount'];
        $data['staff'] = $this->session->userdata('username');
        
        $data['installment'] = 4;//$loan['interest_realization'];
        $data['interest_realization'] = $loan['interest_realization'];

        $q = "call do_new_loan(?,?,?,?,?,?,?,?,?)";
        $this->db->query($q,$data);

        $q = "select @msg msg";
        echo $this->db->query($q)->row()->msg;
    }

    function get_loan_borrower($id)
    {
        $q = "select a.*,concat(firstname,' ',middlename,' ',lastname)name from clients a left join appliedloans b on a.code=b.applicant and (b.id = '$id' or b.loan_ref = '$id') ";
        return $this->db->query($q)->row();
    }

    function get_loan_borrower_($id)
    {
        $q = "select a.*,concat(firstname,' ',middlename,' ',lastname)name from clients a where a.id = '$id' ";
        return $this->db->query($q)->row();
    }

    function get_loan_master($id)
    {
        $q = "select a.*,b.interest_rate,b.max_period,b.installments,b.payment_period from appliedloans a,loantypes b where a.loan_type=b.code and (a.id = '$id' or a.loan_ref = '$id') ";
        return $this->db->query($q)->row();
    }

    function get_client_repayments($id)
    {
        $q = "select a.* from repayments a,appliedloans b where a.loan_ref=b.loan_ref and (b.id = '$id' or b.loan_ref = '$id') ";
        return $this->db->query($q)->result();
    }   

    function get_loan_record($id)
    {
        $q = "select a.*,b.bod_date,b.mobile from appliedloans a,clients b where a.applicant=b.code and (a.id = '$id' or a.loan_ref = '$id') ";
        return $this->db->query($q)->row();
    }

   function get_loan_schedule($ref)
   {
        $q = "select * from loan_repayment_schedule where loanref = '$ref' order by id";
        return $this->db->query($q)->result();
   }

   function get_loan_schedule_excel($ref)
   {
        $q = "select * from loan_repayment_schedule where loanref = '$ref' order by id";

        $this->load->dbutil();
        $q=$this->db->query($q);
        $delimiter = ",";
        $newline = "\n\r";
        
        return $this->dbutil->csv_from_result($q,$delimiter,$newline);
   }

   function get_due_loans()
   {
        $q = "select * from vw_due_loans";
        return $this->db->query($q)->result();
   }

   function get_active_loans()
   {
        $q = "select * from vw_active_loans";
        return $this->db->query($q)->result();
   }

   function get_arrears_loans()
   {
        $q = "select * from vw_active_loans";
        return $this->db->query($q)->result();
   }

    function get_active_loans_($requestData,&$totalData,&$totalFiltered,&$total_loans) 
    { 
        $table = 'vw_active_loans';
        //$table = 'vw_appliedloans';

        $columns = array( 
            0 => 'loan_ref',
            1 => 'applicant_name',
            2 => 'amount',
            3 => 'loan_officer',
            4 => 'branch',
            5 => 'due',
            6 => 'paid',
            7 => 'balance',
            8 => 'nextdue',
            9 => 'status',
            10 => 'applicant',
            11 => 'loan_type',
            12 => 'date_applied',
            13 => 'interest',
            14 => 'id'
        );

        $sql = "select ifnull(sum(due),0) total from $table where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $total_loans = $this->db->query($sql)->row()->total;

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", ".$columns[10].",
         ".$columns[11].",".$columns[12].",".$columns[13].",".$columns[14]." FROM ".$table." where 1 ";


        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.= " ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();

    }

    function get_due_loans_($requestData,&$totalData,&$totalFiltered) 
    { 
        $table = 'vw_due_loans';

        $columns = array( 
            0 => 'loan_ref',
            1 => 'applicant_name',
            2 => 'amount',
            3 => 'loan_officer',
            4 => 'branch',
            5 => 'due',
            6 => 'paid',
            7 => 'balance',
            8 => 'nextdue',
            9 => 'status',
            10 => 'applicant',
            11 => 'loan_type',
            12 => 'date_applied',
            13 => 'interest',
            14 => 'id',
            15 => 'arrears_days',
            16 => 'arrears_amt',
        );

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", ".$columns[10].",
         ".$columns[11].",".$columns[12].",".$columns[13].",".$columns[14].",".$columns[15].",".$columns[16]." FROM ".$table." where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.= " ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();

    }


    function get_fully_paid_loans_list_($requestData,&$totalData,&$totalFiltered,&$total_loans) 
    { 
        $table = 'vw_fully_paid_loans';

        $columns = array( 
            0 => 'loan_ref',
            1 => 'applicant_name',
            2 => 'amount',
            3 => 'loan_officer',
            4 => 'branch',
            5 => 'due',
            6 => 'paid',
            7 => 'balance',
            8 => 'nextdue',
            9 => 'loan_type',
            10 => 'telephone',
            11 => 'date_applied',
        );


        $sql = "select ifnull(sum(amount),0) total from $table where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $total_loans = $this->db->query($sql)->row()->total;

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].",
         ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].
         ", ".$columns[9].", ".$columns[10].", ".$columns[11].
         " FROM ".$table." where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.= " ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();

    }

    function get_arrears_loans_($requestData,&$totalData,&$totalFiltered,&$total_loans,&$total_principal,&$arrears_amt,&$arrears_days) 
    { 
        $table = 'vw_arrears_loans';

        $columns = array( 
            0 => 'loan_ref',
            1 => 'applicant_name',
            2 => 'amount',
            3 => 'loan_officer',
            4 => 'branch',
            5 => 'due',
            6 => 'paid',
            7 => 'balance',
            8 => 'nextdue',
            9 => 'status',
            10 => 'loan_type',
            10 => 'arrears_amt',
            11 => 'loan_type',
            12 => 'id',
            13 => 'arrears_days',
            14 => 'interest',
        );


        $sql = "select ifnull(sum(amount),0) total,
                ifnull(sum(balance),0)principal,
                ifnull(sum(arrears_amt),0)arrears_amt,
                ifnull(sum(arrears_days),0)arrears_days 
                from $table where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $row= $this->db->query($sql)->row();
        $total_loans = $row->total;
        $total_principal = $row->principal;
        $arrears_amt = $row->arrears_amt;
        $arrears_days = $row->arrears_days;

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].",
         ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", 
        ".$columns[10].", ".$columns[11].", ".$columns[12].", ".$columns[13].", ".$columns[14].
        " FROM ".$table." where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.= " ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();

    }

    function get_pending_loans_($requestData,&$totalData,&$totalFiltered,&$total_loans) 
    { 
        $table = 'vw_pending_loans';

        $columns = array( 
            0 => 'loan_ref',
            1 => 'applicant_name',
            2 => 'amount',
            3 => 'loan_officer',
            4 => 'branch',
            5 => 'telephone',
            6 => 'paid',
            7 => 'balance',
            8 => 'nextdue',
            9 => 'status',
            10 => 'applicant',
            11 => 'loan_type',
            12 => 'date_applied',
            13 => 'id',
        );


        $sql = "select ifnull(sum(amount),0) total from $table where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $total_loans = $this->db->query($sql)->row()->total;
        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", 
        ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", ".$columns[10].",
         ".$columns[11].",".$columns[12].",".$columns[13]." FROM ".$table." where 1 ";

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.= " ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();

    }

    function get_rejected_loans_($requestData,&$totalData,&$totalFiltered,&$total_loans) 
    { 
        $table = 'vw_rejected_loans';

        $columns = array( 
            0 => 'loan_ref',
            1 => 'applicant_name',
            2 => 'amount',
            3 => 'loan_officer',
            4 => 'branch',
            5 => 'date_applied',
            6 => 'loan_type',
            7 => 'balance',
            8 => 'nextdue',
            9 => 'status',
            10 => 'applicant',
            11 => 'date_rejected',
            12 => 'appraised_by',
            13 => 'appraisers_reason',
            14 => 'id'
        );


        $sql = "select ifnull(sum(amount),0) total from $table where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $total_loans = $this->db->query($sql)->row()->total;

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", ".$columns[10].", ".$columns[11].", "
            .$columns[12].", ".$columns[13].", ".$columns[14]." 
            FROM ".$table." where 1 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date_applied  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date_applied  <= '$dateTo' ";
            }
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.= " ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();

    }

    function get_approval_reasons()
    {
        return $this->db->query("select * from loan_approval_reasons order by code")->result();
    }

    function approve_loan($loan)
    {
        $data = array();
        $data['loan_ref'] = $loan['loan_ref'];
        $data['approve_reason'] = $loan['approve_reason'];
        $data['approve_remarks'] = $loan['approve_remarks'];
        $data['staff'] = $this->session->userdata('username');

        $q = "call do_approve_loan(?,?,?,?)";

        $this->db->query($q,$data);

        return $this->db->query("select @msg msg")->row()->msg;
    }

    function reject_loan($loan)
    {
        $data = array();
        $data['loan_ref'] = $loan['loan_ref'];
        $data['approve_reason'] = $loan['approve_reason'];
        $data['approve_remarks'] = $loan['approve_remarks'];
        $data['staff'] = $this->session->userdata('username');

        $q = "call do_reject_loan(?,?,?,?)";

        $this->db->query($q,$data);

        return $this->db->query("select @msg msg")->row()->msg;
    }

    function get_loan_collateral_($requestData,&$totalData,&$totalFiltered)
    {
        $table = 'vw_rejected_loans';

        $columns = array( 
            0 => 'loan_ref',
            1 => 'applicant_name',
            2 => 'amount',
            3 => 'loan_officer',
            4 => 'branch',
            5 => 'date_applied',
            6 => 'loan_type',
            7 => 'balance',
            8 => 'nextdue',
            9 => 'status',
            10 => 'applicant',
            11 => 'date_rejected',
            12 => 'appraised_by',
            13 => 'appraisers_reason',
            14 => 'id'
        );

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", ".$columns[10].", ".$columns[11].", "
            .$columns[12].", ".$columns[13].", ".$columns[14]." 
            FROM ".$table." where id < 0 ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.= " ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();

    }

    function get_daily_collection_sheet($sheet,$dateFrom,$dateTo)
    {
        //$dateFrom = $sheet['dateFrom'];
        //$dateTo = $sheet['dateTo'];
        
        $q = "select * from vw_collection_sheet where dt between '$dateFrom' and '$dateTo' order by dt";
        return $this->db->query($q)->result();
    }

   function get_daily_collection_sheet_excel($sheet,$dateFrom,$dateTo)
    {
        //$dateFrom = $sheet['dateFrom'];
        //$dateTo = $sheet['dateTo'];
        
        $q = "select * from vw_collection_sheet where dt between '$dateFrom' and '$dateTo' order by dt";

        $this->load->dbutil();
        $q=$this->db->query($q);
        $delimiter = ",";
        $newline = "\r\n";
        
        return $this->dbutil->csv_from_result($q,$delimiter,$newline);
    }

    function get_repayments_list_($requestData,&$totalData,&$totalFiltered,$status,&$total,&$balance) 
    {
        $table = 'repayments';

        $columns = array( 
            0 => 'loan_ref',
            1 => 'name',
            2 => 'amount',
            3 => 'loan_officer',
            4 => 'branch',
            5 => 'dt',
            6 => 'loan_type',
            7 => 'balance',
            8 => 'nextduedate',
            9 => 'status',
            10 => 'pdate',
            11 => 'tran_ref',
            12 => 'tran_type',
            13 => 'ref',
        );


        $sql = "select ifnull(sum(amount),0) total,ifnull(sum(balance),0) balance from $table where status = '$status' ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and pdate  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and pdate  <= '$dateTo' ";
            }
        }
        $totals = $this->db->query($sql)->row();
        $total = $totals->total;
        $balance = $totals->balance;

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", 
        ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", ".$columns[10].",
         ".$columns[11].", ".$columns[12].", ".$columns[13]."
            FROM ".$table." where status = '$status' ";

        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        if ($this->session->userdata('role') == 'BRANCHMANAGER') {
            $me = $this->session->userdata('branch');
            $sql .= " and branch = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and pdate  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and pdate  <= '$dateTo' ";
            }
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.= " ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();

    }

    function add_repayment($repayment)
    {
        $data = array(
            'borrower' => $repayment['borrower'],
            'loan_officer' => $repayment['loan_officer'],
            'branch' => $repayment['branch'],
            'loan_amount' => $repayment['loan_amount'],
            'repayment' => $repayment['repayment'],
            'trans_mode' => $repayment['trans_mode'],
            'trans_ref' => $repayment['trans_ref'],
            'pay_date' => $repayment['pay_date'],
            'staff' => $this->session->userdata('username'),
            'trans_type' => '',
            'loan_ref' => '',

        );

        $q = "call do_add_repayment(?,?,?,?,?,?,?,?,?,?,?)";

        $this->db->query($q,$data);

        echo $this->db->query("select @msg msg")->row()->msg;
    }

    function post_repayment($ref,$remarks,$date)
    {
        $data = array(
            'ref' => $ref,
            'date' => $date,
            'remarks' => $remarks,
            'staff' => $this->session->userdata('username'),
        );

        $q = "call do_post_repayment(?,?,?,?)";

        $this->db->query($q,$data);

        echo $this->db->query("select @msg msg")->row()->msg;
    }

    function reverse_repayment($ref,$remarks,$date)
    {
        $data = array(
            'ref' => $ref,
            'date' => $date,
            'remarks' => $remarks,
            'staff' => $this->session->userdata('username'),
        );

        $q = "call do_reverse_repayment(?,?,?,?)";

        $this->db->query($q,$data);

        echo $this->db->query("select @msg msg")->row()->msg;
    }

    function get_loan_guarantor_($id)
    {
        $q = "select a.*,concat(firstname,' ',middlename,' ',lastname)name from guarantors a where a.id = '$id' ";
        return $this->db->query($q)->row();
    }

    function get_upcoming_repayments()
    {
        $q = "
                select 
                    a.repayment_date,a.loanref,a.loantype,a.repayment_date,a.repayment,b.applicant,c.loan_officer, 
                    concat(c.firstname,' ',c.middlename,' ',c.lastname)name,c.mobile,c.id 
                from loan_repayment_schedule a,appliedloans b,clients c  
                where a.loanref=b.loan_ref and b.applicant=c.code and repayment_date >= current_date
                order by 1 limit 20
        ";
        return $this->db->query($q)->result();

    }

    function get_my_upcoming_repayments()
    {
        $me = $this->session->userdata('username');

        $q = "
                select 
                    a.repayment_date,a.loanref,a.loantype,a.repayment_date,a.repayment,b.applicant,c.loan_officer, 
                    concat(c.firstname,' ',c.middlename,' ',c.lastname)name,c.mobile,c.id 
                from loan_repayment_schedule a,appliedloans b,clients c  
                where a.loanref=b.loan_ref and b.applicant=c.code and repayment_date >= current_date and c.loan_officer = '$me'
                order by 1 limit 20
        ";
        return $this->db->query($q)->result();

    }

    function get_clients()
    {
        $me = $this->session->userdata('username');

        $q = " 
                select * from vw_clients where 1
                order by name limit 20
        ";
        return $this->db->query($q)->result();
    }

    function get_my_clients()
    {
        $me = $this->session->userdata('username');

        $q = " 
                select * from vw_clients where loan_officer = '$me'
                order by name limit 20
        ";
        return $this->db->query($q)->result();
    }

    function update_loan($loan)
    { 
        parse_str($loan,$loan);
        $data = array(
            'loan_ref' => $loan['loan_ref'],
            'borrower_id' => $loan['borrower_id'],
            'borrower' => $loan['borrower'],
            'loan_officer' => $loan['loan_officer'],
            'branch' => $loan['branch'],
            'loan_type' => $loan['loan_type'],
            'loan_amount' => $loan['loan_amount'],
            'installment' => $loan['installment'],
            'loan_date' => $loan['loan_date'],
            'processing_fee' => $loan['processing_fee'],
            'reason' => $loan['reason'],
            'staff' => $this->session->userdata('username'),
        );

        //$this->audit_trail($loan['borrower']);

        $q = "call do_update_loan(?,?,?,?,?,?,?,?,?,?,?,?)";

        $this->db->query($q,$data);

        echo $this->db->query("select @msg msg")->row()->msg;

    }

    function audit_trail($operation)
    {
        $q = "call do_audit_trail(?,?,?)";

        $data = array(
            'operation' => $operation,
            'staff' => $this->session->userdata('username'),
            'host' => $this->input->ip_address(),
        );

        $this->db->query($q,$data);

    }

    function reverse_loan($loan_ref,$reason)
    {
        $q = "call do_reverse_loan(?,?,?)";

        $data = array(
            'loan_ref' => $loan_ref,
            'reason' => $reason,
            'staff' => $this->session->userdata('username'),
        );

        $this->db->query($q,$data);
        echo $this->db->query("select @msg msg")->row()->msg;
    }


    function get_borrower_load_id($id)
    {
        $q = "
            select id,loan_ref,applicant,applicant_name name,applicant_id id_no,branch,loan_officer,balance*-1 due 
            from vw_appliedloans 
            where id = '$id' 
        ";
        return $this->db->query($q)->row();
    }

    function add_interest_journal($interest)
    {
        parse_str($interest,$interest);
        $data = array(
            'loan_id' => $interest['loan_id'],
            'amount' => $interest['amount'],
            'reference' => $interest['reference'],
            'pay_date' => $interest['pay_date'],
            'staff' => $this->session->userdata('username'),
        );

         $q = "call do_interest_journal(?,?,?,?,?)";

        $this->db->query($q,$data);

        echo $this->db->query("select @msg msg")->row()->msg;
    }

    function getClientIDFromLoanRef($id) {
        $q = "select b.id_number from appliedloans a,clients b where a.applicant=b.code and a.loan_ref = '$id' ";
        return $this->db->query($q)->row()->id_number;
    }
    
    function get_mpesa_payments_list_($requestData,&$totalData,&$totalFiltered,$status,&$total,&$balance)
    {
        $table = 'mpesa_payments';

        $columns = array( 
            0 => 'TransactionType',
            1 => 'TransID',
            2 => 'TransTime',
            3 => 'TransAmount',
            4 => 'BusinessShortCode',
            5 => 'BillRefNumber',
            6 => 'InvoiceNumber',
            7 => 'MSISDN',
            8 => 'First_Name',
            9 => 'Middle_Name',
            10 => 'Last_Name',
            11 => 'OrgAccountBalance',
            12 => 'posted',
            13 => 'receipt_ref',
        );


        $sql = "select ifnull(sum(TransAmount),0) total,0 balance from $table where 1 ";

/*        
        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        
        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
*/
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date(TransTime)  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date(TransTime)  <= '$dateTo' ";
            }
        }
        $totals = $this->db->query($sql)->row();
        $total = $totals->total;
        $balance = $totals->balance;

        $sql = "SELECT @id:=@id+1 as id,".$columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", 
        ".$columns[4].", ".$columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].", ".$columns[10].",
         ".$columns[11].",".$columns[12].",".$columns[13]."
            FROM ".$table." where 1 ";
/*
        if ($this->session->userdata('role') == 'LOANOFFICER') {
            $me = $this->session->userdata('username');
            $sql .= " and loan_officer = '$me' ";
        }

        $loan_type = $requestData['loan_type'];        
        if (isset($loan_type)) {if($loan_type != "") $sql .= " and loan_type = '$loan_type' ";}
        $loan_officer = $requestData['loan_officer'];        
        if (isset($loan_officer)) {if($loan_officer != "")$sql .= " and loan_officer = '$loan_officer' ";}
        $branch = $requestData['branch'];        
        if (isset($branch)) {if($branch != "")$sql .= " and branch = '$branch' ";}
        $loan_status = $requestData['loan_status'];        
        if (isset($loan_status)) {if($loan_status != "")$sql .= " and status = '$loan_status' ";}
*/
        $dateFrom = $requestData['date_from'];        
        if (isset($dateFrom)) {
            if($dateFrom != "") {
                $dateFrom = explode('-',$dateFrom);
                $dateFrom = $dateFrom[2] . '-' . $dateFrom[1] . '-' . $dateFrom[0];
                $sql .= " and date(TransTime)  >= '$dateFrom' ";
            }
        }
        $dateTo = $requestData['date_to'];        
        if (isset($dateTo)) {
            if($dateTo != ""){
                $dateTo = explode('-',$dateTo);
                $dateTo = $dateTo[2] . '-' . $dateTo[1] . '-' . $dateTo[0];
                $sql .= " and date(TransTime)  <= '$dateTo' ";
            }
        }

        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.= " ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();

    }


}