<?php

class Daraja_Model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function get_timestamp()
	{
		return date("YmdHis");
	} 
      
    public function register_url()
    {
	    $url = 'https://api.safaricom.co.ke/mpesa/c2b/v1/registerurl';
 
	    $shortcode = '4083441';
	    $confirmation_url = 'https://www.frontierkenyacredit.com/apps/receipts/confirmation';
		$validation_url = 'https://www.frontierkenyacredit.com/apps/receipts/validation';

	    //$pass = $this->encryt();
		$token = $this->token('c2b');
	    
	    $data = array(
			'ShortCode' => $shortcode,
			'ResponseType' => 'Cancelled',
			'ConfirmationURL' => $confirmation_url,
			'ValidationURL' => $validation_url,
		);
		
	    $data_string = json_encode($data);
        $curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json','Authorization:Bearer '.$token)); 
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

		$curl_response = curl_exec($curl);

		return $curl_response;
    }
    
	public function base_64($b2c='b2c')
	{
		if ($b2c=='b2c') {
			$key = '2gfIUCdWsC3G5rh41CjA4XyRkwsdRYUr';
			$secret = 'Lyk6JECLJcGN0cSt';
		} else if ($b2c=='c2b') {
			$key = '2gfIUCdWsC3G5rh41CjA4XyRkwsdRYUr';
			$secret = 'Lyk6JECLJcGN0cSt';
		} else {
			$key = '2gfIUCdWsC3G5rh41CjA4XyRkwsdRYUr';
			$secret = 'Lyk6JECLJcGN0cSt';
		}
		
		$base64 = base64_encode($key.':'.$secret);

		return $base64;
	}

	public function token($b2c='b2c')
	{
		$url = 'https://api.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials';

		$base64 = $this->base_64($b2c);

		$request_headers = array();
		$request_headers[] = 'Authorization: Basic ' . $base64;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 60);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$data = curl_exec($ch);

		if (curl_errno($ch))
		{
			$token = '';
		}
		else
		{
			$transaction = json_decode($data, TRUE);
			$token = $transaction['access_token'];			
		}
		
		return $token;
	}

	public function stk_push($payer="",$ref="",$amount="",$trandesc="")
	{
		$passkey = 'c4517ef6b5af3b6b0613ece0425127bfbea5366ed1923f549e0a2db5d58a0c15';
		$url = 'https://api.safaricom.co.ke/mpesa/stkpush/v1/processrequest';

		$shortcode = "480301"; 
		$callback_url = 'https://frontierkenyacredit.com.com/apps/receipts/index.php/daraja/validate_stk_push';
		$trantype = "CustomerPayBillOnline";
			
		$token = $this->token('c2b');
		$tm = $this->get_timestamp();

		$pass = $shortcode.$passkey.$tm;
		
		$pass = base64_encode($pass);

		$data = array(
			'BusinessShortCode' => $shortcode,
			'Password' => $pass,
			'Timestamp' => $tm,
			'TransactionType' => $trantype,
			'Amount' => $amount,
			'PartyA' => $payer,
			'PartyB' => $shortcode,
			'PhoneNumber' => $payer,
			'CallBackURL' => $callback_url,
			'AccountReference' => $ref,
			'TransactionDesc' => $trandesc
		);

		$data_string = json_encode($data);
        $curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json','Authorization:Bearer '.$token)); 
	    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

		$curl_response = curl_exec($curl);

		$msg = 'Repayment request sent to LITTLEPESA. Please await response from MPESA to key in PIN to complete transaction.';
		
        return $msg;
	}
	
	public function b2c($payee,$amount,$ref,$remarks)
	{
	    $url = 'https://api.safaricom.co.ke/mpesa/b2c/v1/paymentrequest';

        $initiator = 'LITTLEPESAB2C';
	    //$command = 'BusinessPayment';
	    //$command = "PromotionPayment";
	    $command = "SalaryPayment";
	    $shortcode = '480301';
	    $timeout_url = 'https://frontierkenyacredit.com.com/apps/receipts/validate_repayment';
		$callback_url = 'https://frontierkenyacredit.com.com/apps/receipts/validate_repayment';
		$occassion = 'Please pay on time to avoid default';
		
	    $pass = $this->encryt();
		$token = $this->token('b2c');
	    
	    $data = array(
			'InitiatorName' => $initiator,
			'SecurityCredential' => $pass,
			'CommandID' => $command,
			'Amount' => $amount,
			'PartyA' => $shortcode,
			'PartyB' => $payee,
			'Remarks' => $remarks,
			'QueueTimeOutURL' => $timeout_url,
			'ResultURL' => $callback_url,
			'Occassion' => $occassion
		);
		
	    $data_string = json_encode($data);
        $curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json','Authorization:Bearer '.$token)); 
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

		$curl_response = curl_exec($curl);

		return $curl_response;
	}
	
	public function b2b()
	{
	    $url = 'https://api.safaricom.co.ke/mpesa/b2b/v1/paymentrequest';

        $initiator = 'LITTLEPESAB2C';
	    $command = 'BusinessPayBill';
	    $PartyA = '480301';
	    $PartyB = '480301';
		$amount = '100';
	    $ref = '7 Days Loan';
	    $timeout_url = 'https://frontierkenyacredit.com.com/apps/receipts/validate_repayment';
		$callback_url = 'https://frontierkenyacredit.com.com/apps/receipts/validate_repayment';
		$remarks = '7 days loan';
		$occassion = 'Please pay on time to avoid default';
		
	    $pass = $this->encryt();
		$token = $this->token('b2b');
	    
	    $data = array(
			'Initiator' => $initiator,
			'SecurityCredential' => $pass,
			'CommandID' => $command,
			'SenderIdentifierType' => "4",
			'RecieverIdentifierType' => "4",
			'Amount' => $amount,
			'PartyA' => $PartyA,
			'PartyB' => $PartyB,
			'AccountReference' => $ref,
			'Remarks' => $remarks,
			'QueueTimeOutURL' => $timeout_url,
			'ResultURL' => $callback_url
		);
		
	    $data_string = json_encode($data);
	    
        $curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json','Authorization:Bearer '.$token)); 
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

	    echo 'Content-Type:application/json','Authorization:Bearer '.$token;
        echo '<br>';
	    echo $data_string;

		$curl_response = curl_exec($curl);

		return $curl_response;
	}
	
	public function encryt()
	{
        $plaintext = "frontierkenyacredit.com%2018";
        
        $fp = fopen("//home/frontierkenyacredit.comc/public_html/apps/receipts/keys/pk_cert.pem","r");
        
        $pub_key = fread($fp,8192);
        fclose($fp);
        
        openssl_get_publickey($pub_key);
        openssl_public_encrypt($plaintext,$crypttext,$pub_key);
        
        $c = base64_encode($crypttext);
        
        return $c;
	}
	
	public function validate_stk_push() 
	{
	    try
        {
            header("Content-Type:application/json");
            $resp = '{"ResultCode":0,"ResultDesc":"Validation passed successfully"}';
            $postData = file_get_contents('php://input');
            $filePath = "/home/frontierkenyacredit.comc/public_html/logs/validate_client.txt";
            $errorLog = "/home/frontierkenyacredit.comc/public_html/logs/errors.txt";
            $file = fopen($filePath,"a");
            fwrite($file, $postData);
            fwrite($file,"\r\n");
        	fwrite($file,$resp);
        	fclose($file);
            
            $this->log_mpesa_stk_push($postData);
            
        } catch (Exception $ex) {
            $logErr = fopen($errorLog,"a");
            fwrite($logErr, $ex->getMessage());
            fwrite($logErr,"\r\n");
            fclose($logErr);
            $resp = '{"ResultCode": 1, "ResultDesc":"Validation failure due to internal service error"}';
        }
        
        return $resp;
    }
    
    public function log_mpesa_stk_push($request)
    {
        $request = json_decode($request);
        $request = $request->Body->stkCallback;
        
        $MerchantRequestID = $request->MerchantRequestID;
        $CheckoutRequestID = $request->CheckoutRequestID;
        $ResultCode = $request->ResultCode;
        $ResultDesc = $request->ResultDesc;
        $CallbackMetadata = $request->CallbackMetadata->Item;
        
        foreach ($CallbackMetadata as $c) {
            if (isset($c->Value)) {
                $key = $c->Name;
                $value = $c->Value;
                if ($key == 'Amount') {$Amount = $value;}
                if ($key == 'MpesaReceiptNumber') {$MpesaReceiptNumber = $value;}
                if ($key == 'TransactionDate') {$TransactionDate = $value;}
                if ($key == 'PhoneNumber') {$PhoneNumber = $value;}
            }
        }   
        
        $this->repayy_loan($PhoneNumber,$Amount,$MpesaReceiptNumber);
        
    }
    
    public function repayy_loan($PhoneNumber,$Amount,$MpesaReceiptNumber)
	{
            $msg = 'Dear customer Your repayment of '.$Amount.' Ref '.$MpesaReceiptNumber.' has been received! ';
        
        $this->Messaging_Model->send_sms($PhoneNumber,$msg);
        
		return 0;//json_encode($response);
        
        /*
		$login = $this->Messaging_Model->get_loanee_id($PhoneNumber);
		$loan_ref = $login;
		$company = $this->Messaging_Model->get_loanee_company($login);
	    $balance = $this->App_Model->loan_balance_id($loan_ref);
		$loan_type = '';
		$repay_date = date('Y-m-d');
		$repay_amount = $Amount;
        
        $loan_type = 'Loan Repayment';

        $response = $this->App_Model->repay_loan($company,$login,$loan_type,$repay_date,$repay_amount,$MpesaReceiptNumber);
        
        $customer = $this->Messaging_Model->get_loanee($PhoneNumber);
        
        if ((int)$balance <= (int)$Amount) {
            $msg = 'Dear '.$customer.' Your repayment of '.$Amount.' Loan '.$loan_ref.' Ref '.$MpesaReceiptNumber.' has been received! Loan is fully settled.';
        } else { 
            $msg = 'Dear '.$customer.' Your repayment of '.$Amount.' Loan '.$loan_ref.' Ref '.$MpesaReceiptNumber.' has been received! The balance is Kshs '.number_format($balance - $Amount).'.';
        }
        $this->Messaging_Model->send_sms($PhoneNumber,$msg);
        
		return json_encode($response);
		*/
	}
	
    public function log_mpesa_c2b($array)
    {
        $transactiontype= mysqli_real_escape_string($con,$array['TransactionType']); 
        $transid=mysqli_real_escape_string($con,$array['TransID']); 
        $transtime= mysqli_real_escape_string($con,$array['TransTime']); 
        $transamount= mysqli_real_escape_string($con,$array['TransAmount']); 
        $businessshortcode=  mysqli_real_escape_string($con,$array['BusinessShortCode']); 
        $billrefno=  mysqli_real_escape_string($con,$array['BillRefNumber']); 
        $invoiceno=  mysqli_real_escape_string($con,$array['InvoiceNumber']); 
        $msisdn=  mysqli_real_escape_string($con,$array['MSISDN']); 
        $orgaccountbalance=   mysqli_real_escape_string($con,$array['OrgAccountBalance']); 
        $firstname=mysqli_real_escape_string($con,$array['FirstName']); 
        $middlename=mysqli_real_escape_string($con,$array['MiddleName']); 
        $lastname=mysqli_real_escape_string($con,$array['LastName']); 
        
        $sql="INSERT INTO mpesa_payments
        ( 
            TransactionType,
            TransID,
            TransTime,
            TransAmount,
            BusinessShortCode,
            BillRefNumber,
            InvoiceNumber,
            MSISDN,
            First_Name,
            Middle_Name,
            Last_Name,
            OrgAccountBalance
        )  
        VALUES  
        ( 
            '$transactiontype', 
            '$transid', 
            '$transtime', 
            '$transamount', 
            '$businessshortcode', 
            '$billrefno', 
            '$invoiceno', 
            '$msisdn',
            '$firstname', 
            '$middlename', 
            '$lastname', 
            '$orgaccountbalance' 
        )";
        
    }
    
}