<?php

class Messaging_Model extends CI_Model {

    public function __construct() {
        parent::__construct();
        date_default_timezone_set('Africa/Nairobi');
    }
    
    function get_fcm_token($id)
    {
        return $this->db->query("select fcm from staff_loanees where id = '$id' ")->row()->fcm;
    }
    
    function notify($id='',$title='',$message='')
    {
        $this->fcm_notify($id,$title,$message); 
        $to = $this->get_loanee_telephone($id);
        $this->send_sms($to,$message); 
    }
    
    function get_loanee_telephone($id)
    {
        return $this->db->query("select telephone from staff_loanees where id = '$id' ")->row()->telephone;
    }
    
    function get_loanee_telephonee($id)
    {
        return $this->db->query("select concat('254',substr(telephone,-9)) telephone from staff_loanees where id = '$id' ")->row()->telephone;
    }
    
    function get_loanee_company($id)
    {
        return $this->db->query("select company from staff_loanees where id = '$id' ")->row()->company;
    }
    
    function get_loanee($tel)
    {
        return $this->db->query("select staff_name from staff_loanees where substr(telephone,-9) = substr('$tel',-9) ")->row()->staff_name;
    }
    
    function get_loanee_id_name($id)
    {
        $q = "select staff_name from staff_loanees where id = '$id' ";
        $query = $this->db->query($q);
        if ($query->num_rows() > 0) {
            return $query->row()->staff_name;
        } else {
            return $id;
        }
    }

    function get_loanee_id($tel)
    {
        return $this->db->query("select id from staff_loanees where substr(telephone,-9) = substr('$tel',-9) ")->row()->id;
    }

    function fcm_notify($id='',$title='',$message='')
    {
        /*
        $token = '';

        if ($id == ''){
            $id = 'admin';
        }

        $token = $this->get_fcm_token($id);
        $n_from = $id;
        $n_to = $id;
        
        $q = "
            insert into notifications(n_to,n_from,title,details,dt) 
            values('$n_to','$n_from','$title','$message',now())
        ";
        $this->db->query($q);
        
        if ($title == ''){
            $title = 'New Year Wishes';
        }

        if ($message == ''){
            $message = 'Wishing you a phosphorus YEAR 2018.';
        }

        $devicetoken [] = $token;

        $res = array();

        $res['notification']['title'] = $title;
        $res['notification']['message'] = $message;
        $res['notification']['image'] = base_url()."assets/images/logo_tinny.png";

        $res['data']['title'] = $title;
        $res['data']['message'] = $message;
        $res['data']['image'] = base_url()."assets/images/logo_tinny.png";

        $firebase = new Firebase(); 

        //$firebase->send($devicetoken, $res);
        */
    }
    
    function send_sms($recipient='',$message='')
    {
        $q = "
            select count(1) c from sms_sent 
            where phone = '$recipient' and sms = '$message' 
            and date_add(dt,interval 5 minute) > now()
        ";
        
        $repeat = $this->db->query($q)->row()->c;
        
        if ($repeat < 10 ) {
            $q = "
                insert into sms_sent(phone,sms,dt) 
                values ('$recipient','$message',now())
            ";
            $this->db->query($q);
            
            $username   = "IMARASMS";
            $apikey     = "75eb28dcf0ece9c7a35b538b19adc40d6c79c997ff70b3073547d54ec6e75ea9";
            $from = "IMARAPRMIER";
    
    		$gateway    = new AfricasTalkingGateway($username, $apikey);
    		
    		try 
    		{ 
    		  $results = $gateway->sendMessage($recipient, $message,$from);
    		    
    		}
    		catch ( AfricasTalkingGatewayException $e )
    		{
    		  echo "Encountered an error while sending sms!";
    		}
        }
    }
    
    function send_smses()
    {
        $q = "select phone,sms from sms_send where status = 0 order by id";
        $query = $this->db->query($q)->result();
        foreach ($query as $s) {
            $this->send_sms($s->phone,$s->sms);  
        }
        
        $q = "update sms_send set status = 1,dt_sent=now() where status = 0";
        $this->db->query($q);
    }
    
}