        <script>
            jQuery(document).ready(function($){
               $('.loan_tabs').pwstabs({
                   effect: 'none',
                   defaultTab: 1,
                   containerWidth: '100%', 
                   responsive: false,
                   theme: 'pws_theme_grey'
               }) 
            });
        </script>  

        <section class="content-header">
            <h1><?php echo $borrower->title;?>&nbsp;&nbsp;<?php echo $borrower->firstname.' '.$borrower->middlename.' '.$borrower->lastname; ?> #<?php echo $borrower->code;?> - View Loan 
            </h1>
        </section>

    <section class="content">
        <div class="box box-widget">
            <div class="box-header with-border">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="user-block">
                            <img class="img-circle" src="<?php echo base_url();?>assets/images/placeholder.png" alt="user image">
                            <span class="username">
                                <?php echo $borrower->firstname.' '.$borrower->middlename.' '.$borrower->lastname; ?>
                            </span>
                            <span class="description" style="font-size:13px; color:#000000"><?php echo $borrower->id_number;?><br>
                                <a href="#" id="borrower_edit" idx="<?php echo $borrower->code;?>">Edit</a><br>Employee<br><?php echo $borrower->gender;?>
                            </span>
                        </div><!-- /.user-block -->         
                    </div><!-- /.col -->
                    <div class="col-sm-4">
                        <ul class="list-unstyled">
                        <li><b>Address:</b> <?php echo $borrower->po_box;?></li>
                        <li><b>Town:</b> <?php echo $borrower->town;?></li>
                        <li><b>Postal Code:</b> <?php echo $borrower->postal_code;?></li>
                        </ul>
                    </div>
                    <div class="col-sm-4">
                        <ul class="list-unstyled">
                        <li><b>Telephone:</b> <?php echo $borrower->mobile;?></li>
                        <div class="btn-group-horizontal">
                            <a type="button" class="btn-xs bg-red" href="#">Send SMS</a>
                        </div>
                        <li><b>Email:</b> <a onclick="javascript:window.open('<?php echo $borrower->email;?>', 'mail');event.preventDefault()" href="<?php echo $borrower->email;?>"><?php echo $borrower->email;?></a>
            <div class="btn-group-horizontal">
                <a type="button" class="btn-xs bg-red" href="#">Send Email</a>
            </div></li>
                        <li><b>Spouse:</b> <?php echo $borrower->spouse;?>
                        <li><b>Telephone:</b> <?php echo $borrower->spouse_mobile;?></li>
                        <div class="btn-group-horizontal">
                            <a type="button" class="btn-xs bg-red" href="#">Send SMS</a>
                        </div>
                        </li>
                        
                        </ul>
                    </div>
                </div><!-- /.row -->
                <div class="row">
                    <div class="col-sm-8">
            <div class="btn-group-horizontal">
                <a type="button" class="btn bg-olive margin" href="#" onclick="load_add_loan('<?php echo $borrower->id_number;?>')">Add Loan</a><a type="button" class="btn bg-navy margin" href="#" onclick="view_all_loans()">View All Loans</a>
            </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="pull-left">
            <div class="input-group-btn">
                <button type="button" class="btn btn-info dropdown-toggle margin" data-toggle="dropdown">Borrower Loans Statement
                    <span class="fa fa-caret-down"></span>
                </button>
                <ul class="dropdown-menu" role="menu">
                
                
                            <li><a href="#" onclick="print_loan_statement('<?php echo $loan->loan_ref;?>')">Print Statement</a></li>
                
                            <li><a href="#" onclick="pdf_loan_statement('<?php echo $loan->loan_ref;?>')">Download in PDF</a></li>
                
                            <li><a href="#" onclick="excel_loan_statement('<?php echo $loan->loan_ref;?>')">Download in Excel</a></li>
                
                            <!-- <li><a href="#" onclick="format_loan_report('<?php echo $loan->loan_ref;?>')">Format Report</a></li> -->
                </ul>
            </div>
                        </div>
                    </div>
                </div>             
            </div> 
        </div>              
                    <div class="box box-info">
                        <div class="box-body table-responsive no-padding">
                            <table class="table table-bordered table-condensed table-hover">
                                <thead>
                                    <tr style="background-color: #D1F9FF">
                                        <th>Loan#</th>
                                        <th>Released</th>
                                        <th>Maturity</th>
                                        <th>Repayment</th>
                                        <th>Principal</th>
                                        <th>Interest Rate</th>
                                        <th>Interest</th>
                                        <th>Fees</th>
                                        <th>Penalty</th>
                                        <th>Due</th>
                                        <th>Paid</th>
                                        <th>Balance</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr><td><?php echo $loan->loan_ref;?></td>    
                                    <td><?php echo $loan->date_disbursed;?></td>               
                                    <td><?php echo $loan->maturity_date;?></td>               
                                    <td><?php echo $loan->loan_type;?></td>               
                                    <td><?php echo $loan->amount;?></td>               
                                    <td><?php echo $loan->interest_rate;?></td>               
                                    <td><?php echo $loan->interest_amount;?></td>               
                                    <td><?php echo $loan->fees;?></td>               
                                    <td><?php echo $loan->penalty;?></td>               
                                    <td><?php echo $loan->amount_due;?>
                                    <br><small><a href="#">Override</a></small>
                                    </td>               
                                    <td><?php echo $loan->amount_paid;?></td>                
                                    <td><?php echo $loan->balance;?></td>                 
                                    <td><span class="label label-primary"><?php echo $loan->status;?></span></td>      
                                </tr></tbody>      
                            </table>
                        </div>
                    </div>
<div class="row row-grid">
    <div id="view_loan_details_pre_loader" style="display: none;">
        <div style="text-align:center; font-weight:bold;font-style:italic;"><i class="fa fa-spinner fa-spin "></i> Loading Loan Details. Please Wait..<br><br></div>
    </div>
</div>


<div class="box no-border">
    <div class="loan_tabs">

        <?php $this->load->view('loans/tabs/repayments'); ?>
        <?php $this->load->view('loans/tabs/terms'); ?>
        <?php $this->load->view('loans/tabs/schedule'); ?>
        <?php $this->load->view('loans/tabs/pending_dues'); ?>
        <?php $this->load->view('loans/tabs/collateral'); ?>
        <?php $this->load->view('loans/tabs/files'); ?>
        <?php $this->load->view('loans/tabs/comments'); ?>
</div>

</div>

</section>


<script type="text/javascript">

    function load_add_loan(id)
    {
        id = id || "undefined";
        var url = '<?php echo base_url();?>vaddloan';
        load_page(url,{id:id});
    }

    function view_all_loans()
    {
        alert('view all loans');
    }

    function print_loan_statement(loan_ref)
    {
        var url = '<?php echo base_url();?>print_loan_statement';
        
        open('POST', url, {'loan_ref':loan_ref,'mode':'PREVIEW'}, '_blank');
    }

    function pdf_loan_statement(loan_ref)
    {
        var url = '<?php echo base_url();?>pdf_loan_statement';
        
        open('POST', url, {'loan_ref':loan_ref,'mode':'PREVIEW'}, '_blank');
    }

    function excel_loan_statement(loan_ref)
    {
        var url = '<?php echo base_url();?>excel_loan_statement';
        
        open('POST', url, {'loan_ref':loan_ref,'mode':'PREVIEW'}, '_blank');
    }

    function format_report()
    {
        alert(arguments.callee.name);
    }

    function add_repayment(id)
    {
        id = id || "undefined";
        var url = '<?php echo base_url();?>repayment';
        load_page(url,{id:id});
    }

    function print_csv()
    {
        alert(arguments.callee.name);        
    }

    function restructure(n)
    {
        alert(arguments.callee.name + ' '+n)
    }

    function edit_loan()
    {
        alert(arguments.callee.name)
    }

    function delete_loan()
    {
        alert(arguments.callee.name)
    }

</script>



