<?php
    if ($borrower == 'undefined') {$borrower = '';}
?>
 
<form  class="form-horizontal" enctype="multipart/form-data" id="frm_add_new_loan">
    <div class="box-body">
 
         <div class="form-group"> 
            <label for="borrower" class="col-sm-3 control-label">Borrower ID #</label>                      
            <div class="col-sm-3">
                <input 
                    type="text" 
                    name="borrower_id" 
                    class="form-control" 
                    id="borrower_id" 
                    placeholder="" 
                    value="<?php echo $borrower; ?>"
                >
            </div>
            <div class="col-sm-3">
                <label>Click [ENTER] to search using ID</label>
            </div>
        </div>

        <div class="form-group">
            <label for="borrower" class="col-sm-3 control-label">Borrower</label>                      
            <div class="col-sm-6">
                <select id="borrower" class="form-control" name="borrower" >
                    <option value=""></option>
                    <?php foreach ($clients as $c) {?>
                        <option value="<?php echo $c->code;?>"><?php echo $c->name;?></option>
                    <?php } ?>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="borrower" class="col-sm-3 control-label">Loan Officer</label>                      
            <div class="col-sm-6">
                <select id="loan_officer" class="form-control" name="loan_officer" >
                    <option value=""></option>
                    <?php foreach ($loan_officers as $l) {?>
                        <option value="<?php echo $l->code;?>"><?php echo $l->name;?></option>
                    <?php } ?>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="branch" class="col-sm-3 control-label">Branch</label>                      
            <div class="col-sm-6">
                <select id="branch" class="form-control" name="branch" >
                    <option value=""></option>
                    <?php foreach ($branches as $b) {?>
                        <option value="<?php echo $b->code;?>"><?php echo $b->name;?></option>
                    <?php } ?>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="inputBorrowerGender" class="col-sm-3 control-label">Loan type</label>                      
            <div class="col-sm-6">
                <select class="form-control" name="loan_type" placeholeder="Enter loan type" id="loan_type">
                    <option value=""></option>
                    <?php foreach ($loanTypes as $l) {?>
                        <option value="<?php echo $l->code;?>"><?php echo $l->name;?></option>
                    <?php } ?>
                </select>
            </div>
        </div> 
        
        <div class="form-group">
            <label for="loan_amount" class="col-sm-3 control-label">Min/Max Amount</label>                      
            <div class="col-sm-3">
                <input type="text" name="loan_min" class="form-control" id="loan_min" placeholder="" value="0" disabled="disabled">
            </div>
            <div class="col-sm-3">
                <input type="text" name="loan_max" class="form-control" id="loan_max" placeholder="" value="0" disabled="disabled">
            </div>
        </div>

        <div class="form-group">
            <label for="loan_amount" class="col-sm-3 control-label">Loan Amount</label>                      
            <div class="col-sm-3">
                <input type="text" name="loan_amount" class="form-control" id="loan_amount" placeholder="Loan amount in Ksh." value="0">
            </div>
        </div>

        <div class="form-group">
            <label for="loan_period" class="col-sm-3 control-label">Disbursement Amount</label>                      
            <div class="col-sm-6">
                <input type="text" name="disbursement" class="form-control" id="disbursement" placeholder="" value="0" disabled="disabled">
            </div>
        </div>

        <div class="form-group">
            <label for="loan_period" class="col-sm-3 control-label">Installments </label>                      
            <div class="col-sm-6">
                <input type="text" name="installment" class="form-control" id="installment" placeholder="" value="0" disabled="disabled">
            </div>
        </div>

        <div class="form-group">
            <label for="loan_payment" class="col-sm-3 control-label">Installment Amount</label>                      
            <div class="col-sm-6">
                <input type="text" name="loan_payment" class="form-control" id="loan_payment" disabled="disabled" value="0">
             </div>
        </div>

        <div class="form-group">
            <label for="loan_date" class="col-sm-3 control-label">Date</label>                      
            <div class="col-sm-6">
                <input type="date" name="loan_date" class="form-control" id="loan_date" value="<?php echo date('Y-m-d');?>">
            </div>
        </div>

        <div class="panel panel-default"><div class="panel-body bg-gray text-bold">Processing:</div></div>

        <div class="form-group">
            <label for="loan_date" class="col-sm-3 control-label">Processing Fee </label>                      
            <div class="col-sm-6">
                <input type="text" name="processing_fee" class="form-control" id="processing_fee" value="0" >
            </div>
        </div>

        <div class="form-group">
            <label for="loan_date" class="col-sm-3 control-label">LGF Required </label>                      
            <div class="col-sm-6">
                <input type="text" name="deposit_required" class="form-control" id="deposit_required" value="" readonly="readonly">
            </div>
        </div>

        <div class="form-group">
            <label for="loan_date" class="col-sm-3 control-label">LGF Paid </label>                      
            <div class="col-sm-6">
                <input type="text" name="deposit_paid" class="form-control" id="deposit_paid" value="" readonly="readonly">
                <input type="hidden" name="interest_realization" class="form-control" id="interest_realization"/>
            </div>
        </div>

        <div class="box-footer">
            <div class="col-sm-3"></div>
            <button id="subMitLoan" class="btn btn-success pull-left">Add New Loan</button>            
        </div>
    </div>        
</form>


<script>
    $(function() {


        if ( $('#borrower_id').val() != "") {
            var borrower = $('#borrower_id').val();
            var url = '<?php echo base_url();?>client/getDetails_ID';
            $(document.body).css({'cursor' : 'wait'});
            $.post(url,{client:borrower},function(o_data,status){
                if (o_data == '') {
                    $("#borrower").val('');
                    $("#loan_officer").val('');
                    $("#branch").val('');
                    $("#loan_amount").val('');
                    alert("NO CUSTOMER WITH THIS ID NO!");
                } else {
                    var data = o_data.substring(1, o_data.length-1);
                    var client = JSON.parse(data); 
                    $("#borrower").val(client.code);
                    $("#loan_officer").val(client.loan_officer);
                    $("#branch").val(client.branch);
                    $("#loan_amount").val(client.loan_amt);
                }
                $(document.body).css({'cursor' : 'default'});
            });        
        }

        $('#borrower_id').off('keypress');
        $('#borrower_id').on('keypress',function(e) {
            if (e.which == 13) {
                e.preventDefault();
                var borrower = $('#borrower_id').val();
                var url = '<?php echo base_url();?>client/getDetails_ID';
                $(document.body).css({'cursor' : 'wait'});
                $.post(url,{client:borrower},function(o_data,status){
                    if (o_data == '') {
                        $("#borrower").val('');
                        $("#loan_officer").val('');
                        $("#branch").val('');
                        alert("NO CUSTOMER WITH THIS ID NO!");
                    } else {
                        var data = o_data.substring(1, o_data.length-1);
                        var client = JSON.parse(data); 
                        $("#borrower").val(client.code);
                        $("#loan_officer").val(client.loan_officer);
                        $("#branch").val(client.branch);
                     }
                    $(document.body).css({'cursor' : 'default'});
                });
            }
        }); 

        $('#subMitLoan').on('click',function(e){
            e.preventDefault();
            if (validated()) {
                if (confirm('Add New Loan?')) {
                    $(document.body).css({'cursor' : 'progress'});
                    var loan = $("#frm_add_new_loan").serialize();
                    var url = '<?php echo base_url();?>new_loan'; 
                    
                    $.post(url,{loan:loan},function(o_data,status){
                        alert(o_data);
                        $(document.body).css({'cursor' : 'default'});
                        if (o_data != 'ANOTHER SIMILAR LOAN ALREADY EXISTS!') {
                            clear_data();
                            $('#modal_add_new_loan').modal('hide');
                        }
                    });
                }
            }
        });

        function clear_data()
        {
            document.forms["frm_add_new_loan"]["borrower"].value = '';
            document.forms["frm_add_new_loan"]["loan_officer"].value = '';
            document.forms["frm_add_new_loan"]["branch"].value = '';
            document.forms["frm_add_new_loan"]["loan_type"].value = '';
            document.forms["frm_add_new_loan"]["loan_amount"].value = '';
            document.forms["frm_add_new_loan"]["loan_date"].value = '';
            document.forms["frm_add_new_loan"]["loan_min"].value = '';
            document.forms["frm_add_new_loan"]["loan_max"].value = '';
            document.forms["frm_add_new_loan"]["installment"].value = '';
            document.forms["frm_add_new_loan"]["loan_payment"].value = '';
            document.forms["frm_add_new_loan"]["disbursement"].value = '';
            document.forms["frm_add_new_loan"]["processing_fee"].value = '';
            document.forms["frm_add_new_loan"]["deposit_required"].value = '';
            document.forms["frm_add_new_loan"]["deposit_paid"].value = '';
        }

        function validated()
        {
            var x = document.forms["frm_add_new_loan"]["borrower"].value;

            if (x == "") {
                alert("Borrower must be filled out");
                document.forms["frm_add_new_loan"]["borrower"].focus();
                return false;
            }

            x = document.forms["frm_add_new_loan"]["loan_officer"].value;
            if (x == "") {
                alert("Loan Officer must be filled out");
                document.forms["frm_add_new_loan"]["loan_officer"].focus();
                return false;
            }

            x = document.forms["frm_add_new_loan"]["branch"].value;
            if (x == "") {
                alert("Branch must be filled out");
                document.forms["frm_add_new_loan"]["branch"].focus();
                return false;
            }

            x = document.forms["frm_add_new_loan"]["loan_type"].value;
            if (x == "") {
                alert("Loan Type must be filled out");
                document.forms["frm_add_new_loan"]["loan_type"].focus();
                return false;
            }

            x = document.forms["frm_add_new_loan"]["loan_amount"].value;
            if (x == "") {
                alert("Loan Amount must be filled out");
                document.forms["frm_add_new_loan"]["loan_amount"].focus();
                return false;
            }

            x = document.forms["frm_add_new_loan"]["loan_date"].value;
            if (x == "") {
                alert("Date must be filled out");
                document.forms["frm_add_new_loan"]["loan_date"].focus();
                return false;
            }

            return true;
        }

        $('#borrower').on('change',function(e){
            e.preventDefault();
            var borrower = $(this).val();
            var url = '<?php echo base_url();?>client/getDetails';
            $(document.body).css({'cursor' : 'wait'});
            $.post(url,{client:borrower},function(o_data,status){
                var data = o_data.substring(1, o_data.length-1);
                var client = JSON.parse(data); 
                $("#loan_officer").val(client.loan_officer);
                $("#branch").val(client.branch);
                $(document.body).css({'cursor' : 'default'});
            });
        });


        $('#loan_type').on('change',function(e){
            e.preventDefault();
            var loan_type = $(this).val();
            var url = '<?php echo base_url();?>client/getLoanType';
            $(document.body).css({'cursor' : 'wait'});
            $.post(url,{loan_type:loan_type},function(o_data,status){
                var loan = JSON.parse(o_data.substring(1, o_data.length-1)); 
                $("#loan_amount").val(loan.min_amount);
                $("#loan_min").val(loan.min_amount);
                $("#loan_max").val(loan.max_amount);
                $("#installment").val(loan.installments);
                $("#interest_realization").val(loan.interest_realization);
                calc_amount();
                $(document.body).css({'cursor' : 'default'});
            });
        });

        $('#loan_amount').on('change',function(e){
            e.preventDefault();
            $(document.body).css({'cursor' : 'wait'});
            calc_amount();
            $(document.body).css({'cursor' : 'default'});
            
        });

    });

    function calc_amount()
    {
        var b = $('#borrower').val();
        var t = $('#loan_type').val();
        var a = $('#loan_amount').val();
        var i = $('#installment').val();
        var int = $('#interest_realization').val();
        var url = '<?php echo base_url();?>new_loan_info';

        $.post(url,{amount:a,type:t,borrower:b,installments:i,interest:int},function(o_data,status){
            var loan = JSON.parse(o_data.substring(1, o_data.length-1)); 
            $("#loan_payment").val(loan.repayt);
            $("#disbursement").val(loan.disbursement);
            $("#processing_fee").val(loan.processing_fee);
            $("#deposit_required").val(loan.deposit_required);
            $("#deposit_paid").val(loan.deposit_paid);
        });
    }
</script>
