      
          <div class="box box-info">
          <div class="box-header"><h4 class="text-bold text-primary">Open Loans</h4></div>
          <div class="box-body">
            <div class="row">
                <div class="col-md-4">
                  <p class="text-center">
                    <strong>Weekly Goal Completion (0%)</strong>
                  </p>
                  <div class="progress-group">
                    <span class="progress-text">Collections/Due</span>
                    <span class="progress-number"><b>0</b>/0</span>

                    <div class="progress sm">
                      <div class="progress-bar progress-bar-red" style="width: 0%"></div>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <p class="text-center">
                    <strong>Monthly Goal Completion (0%)</strong>
                  </p>
                  <div class="progress-group">
                    <span class="progress-text">Collections/Due</span>
                    <span class="progress-number"><b>0</b>/0</span>

                    <div class="progress sm">
                      <div class="progress-bar progress-bar-red" style="width: 0%"></div>
                    </div>
                  </div>
                </div>
                <div class="col-md-4">
                  <p class="text-center">
                    <strong>Yearly Goal Completion (0%)</strong>
                  </p>
                  <div class="progress-group">
                    <span class="progress-text">Collections/Due</span>
                    <span class="progress-number"><b>0</b>/17,500.00</span>

                    <div class="progress sm">
                      <div class="progress-bar progress-bar-red" style="width: 0%"></div>
                    </div>
                  </div>
                </div>
            </div>
          </div>
          </div>
      
          <div class="row margin">
            <form action = "#" class="form-horizontal" method="get"  name="form" id="chart_update">
                <div class="form-group">
                    <label for="HomeChartType" class="col-sm-4 control-label">Generate Below Charts</label>
                    <div class="col-sm-4">
                          <select class="form-control" id="HomeChartType" name="HomeBranchChartsPeriod">
                        <option value="Daily" selected>Daily</option>
                        <option value="Weekly">Weekly</option>
                        <option value="Monthly">Monthly</option>
                        <option value="Quarterly">Quarterly</option>
                        <option value="Half-Yearly">Half-Yearly</option>
                        <option value="Yearly">Yearly</option>
                      </select>
                    </div>
                    <div class="col-sm-4">
                        <button type="submit" class="btn btn-info pull-left" data-loading-text="<i class='fa fa-spinner fa-spin '></i> Please Wait">Submit</button>
                        
            <script type="text/javascript">
            $('#chart_update').on('submit', function(e) {
              
              $(this).find('button[type=submit]').prop('disabled', true);
              $('.btn').prop('disabled', true);
              $('.btn').button('loading');
              return true;
            });
            </script>
                    </div>
                </div>
            </form>
          </div>
      
          <div class="row">
            <div class="col-md-12">
              <!-- AREA CHART -->
              <div class="box box-primary">
                <div class="box-header with-border">
                  <h3 class="box-title"><b><span style="color: #D72828">Loans Released - Daily</span></b></h3>
                  <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                  </div>
                </div>
                <div class="box-body">
                  <div class="chart">
                    <canvas id="loanReleasedChart" style="height:250px"></canvas>
                  </div>
                </div><!-- /.box-body -->
              </div><!-- /.box -->
            </div><!-- /.col (LEFT) -->
          </div>  
          
          <div class="row">
            <div class="col-md-12">
              <!-- AREA CHART -->
              <div class="box box-primary">
                <div class="box-header with-border">
                  <h3 class="box-title"><b><span style="color: #3C8DBC">Loan Collections - Daily</span></b></h3>
                  <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                  </div>
                </div>
                <div class="box-body">
                  <div class="chart">
                    <canvas id="loanCollectedChart" style="height:250px"></canvas>
                  </div>
                </div><!-- /.box-body -->
              </div><!-- /.box -->
            </div><!-- /.col (LEFT) -->
          </div>

          <div class="row">
            <div class="col-md-6">
              <!-- LINE CHART -->
              <div class="box box-info">
                <div class="box-header with-border">
                  <h3 class="box-title"><b>Number of Loans Released - Daily</b></h3>
                  <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                  </div>
                </div>
                <div class="box-body">
                  <div class="chart">
                    <canvas id="numLoansReleasedChart" style="height:265px"></canvas>
                  </div>
                </div><!-- /.box-body -->
              </div><!-- /.box -->
            </div><!-- /.col (LEFT) -->
            <div class="col-md-6">
              <!-- LINE CHART -->
              <div class="box box-info">
                <div class="box-header with-border">
                  <h3 class="box-title"><b>Number of Repayments Collected - Daily</b></h3>
                  <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                  </div>
                </div>
                <div class="box-body">
                  <div class="chart">
                    <canvas id="numRepaymentsCollectedChart" style="height:265px"></canvas>
                  </div>
                </div><!-- /.box-body -->
              </div><!-- /.box -->
            </div><!-- /.col (LEFT) -->
          </div>

          <div class="row">
          
           <div class="col-md-6">
              <div class="box box-info">
                <div class="box-header with-border">
                  <h3 class="box-title"><b>Number of Fully Paid Loans - Daily</b></h3>
                  <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                  </div>
                </div>
                <div class="box-body">
                  <div class="chart">
                    <canvas id="numLoansFullyPaidCollectedChart" style="height:265px"></canvas>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-md-6">
              <div class="box box-info">
                <div class="box-header with-border">
                  <h3 class="box-title"><b>Open Loans Status - To Date</b></h3>
                  <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                  </div>
                </div>
                <div class="box-body">
                    <canvas id="openLoansStatusChart" style="height:265px"></canvas>
                    <div class="row">
                        <div class="col-md-12">
                        <small>
                          <ul class="chart-legend clearfix list-inline">
                            <li><i class="fa fa-circle-o text-green"></i> Loans on Schedule (1  Loans)</li>
                            <li><i class="fa fa-circle-o text-yellow"></i> Missed Repayments (0  Loans)</li>
                            <li><i class="fa fa-circle-o text-red"></i> Past Maturity (0  Loans)</li>
                          </ul>
                          </small>
                        </div>
                    </div>
                </div>
              </div>
            </div>

          </div>
          
          <div class="row">

           <div class="col-md-6">
              <div class="small-box bg-yellow">
                <div class="inner">
                  <h4 class="text-bold">Rate of Recovery (All Loans)</h4>
                  
                  <p>Percentage of the due amount that is paid for <u>all loans</u> until today</p>
                    <h3>0.00%</h3>
                </div>
                <div class="icon">
                  <i class="ion ion-stats-bars"></i>
                </div>
              </div>
            </div>

            <div class="col-md-6">    
              <div class="small-box bg-green">
                <div class="inner">
                  <h4 class="text-bold">Rate of Recovery (Open Loans)</h4>
                  
                  <p>Percentage of the due amount that is paid for <u>open loans</u> until today</p>
                  <h3>0.00%</h3>
                </div>
                <div class="icon">
                  <i class="ion ion-stats-bars"></i>
                </div>
              </div>
            </div>

          </div>

          <div class="row">

             <div class="col-md-6">
                <div class="box box-danger">
                    <div class="box-header with-border">
                      <h3 class="box-title"><b>Rate of Return %  (All Time)</b></h3>
                      <div class="box-tools pull-right">
                        <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                        <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                      </div>
                    </div>
                    <div class="box-body">
                        <p>Percentage of the <b>Total Interest, Fees, and Penalty collected</b> until today out of the <b>Total Principal due</b> until today</p>
                        <div class="progress-group">
                            <span class="progress-text">All Loans</span>
                            <span class="progress-number"><b>0.00</b>/100%</span>
        
                            <div class="progress sm">
                              <div class="progress-bar progress-bar-aqua" style="width: 0.00%"></div>
                            </div>
                        </div>
                        <!-- /.progress-group -->
                        <div class="progress-group">
                            <span class="progress-text">Open Loans</span>
                            <span class="progress-number"><b>0.00</b>/100%</span>
    
                            <div class="progress sm">
                                <div class="progress-bar progress-bar-yellow" style="width: 0.00%"></div>
                            </div>
                        </div>
                        <!-- /.progress-group -->
                        <div class="progress-group">
                            <span class="progress-text">Fully Paid Loans</span>
                            <span class="progress-number"><b>0.00</b>/100%</span>

                            <div class="progress sm">
                                <div class="progress-bar progress-bar-green" style="width: 0.00%"></div>
                            </div>
                        </div>
                        <!-- /.progress-group -->
                        <div class="progress-group">
                            <span class="progress-text">Default Loans</span>
                            <span class="progress-number"><b>0.00</b>/100%</span>

                            <div class="progress sm">
                                <div class="progress-bar progress-bar-red" style="width: 0.00%"></div>
                            </div>
                        </div>
                        <!-- /.progress-group -->
                    </div>
                </div>
             </div>
             <div class="col-md-6">

              <div class="box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title"><b>Active Male / Female Borrowers %  (All Time)</b></h3>
                  <div class="box-tools pull-right">
                    <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                    <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                  </div>
                </div>
                <div class="box-body">
                    <canvas id="genderChart" style="height:265px"></canvas>
                </div>
              </div>
 
            </div>

          </div>

          <div class="row">

            <div class="col-md-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h4 class="text-bold">Average Loan Tenure (All Time)</h4>
                        <p>Average number of days for loans to be fully paid</p>
                        <h3>N/A</h3>
                    </div>
                    <div class="icon">
                        <i class="ion ion-stats-bars"></i>
                    </div>
                </div>
            </div>

           </div>



            <script type="text/javascript">
/*            $(".numeric").numeric();
            $(".positive").numeric({ negative: false });
            $(".positive-integer").numeric({ decimal: false, negative: false });
            $(".decimal-2-places").numeric({ decimalPlaces: 2 });
            $(".decimal-4-places").numeric({ decimalPlaces: 4 });
            $("#remove").click(
                function(e)
                {
                    e.preventDefault();
                    $(".numeric,.positive,.positive-integer,.decimal-2-places,.decimal-4-places").removeNumeric();
                }
            );*/
            </script>
            
            <script>
              $(function () {

                  var areaChartOptions = {
                  //Boolean - If we should show the scale at all
                  showScale: true,
                  //Boolean - Whether grid lines are shown across the chart
                  scaleShowGridLines: true,
                  //String - Colour of the grid lines
                  scaleGridLineColor: "rgba(0,0,0,.05)",
                  //Number - Width of the grid lines
                  scaleGridLineWidth: 1,
                  //Boolean - Whether to show horizontal lines (except X axis)
                  scaleShowHorizontalLines: true,
                  //Boolean - Whether to show vertical lines (except Y axis)
                  scaleShowVerticalLines: true,
                  //Boolean - Whether the line is curved between points
                  bezierCurve: true,
                  //Number - Tension of the bezier curve between points
                  bezierCurveTension: 0.3,
                  //Boolean - Whether to show a dot for each point
                  pointDot: true,
                  //Number - Radius of each point dot in pixels
                  pointDotRadius: 4,
                  //Number - Pixel width of point dot stroke
                  pointDotStrokeWidth: 1,
                  //Number - amount extra to add to the radius to cater for hit detection outside the drawn point
                  pointHitDetectionRadius: 20,
                  //Boolean - Whether to show a stroke for datasets
                  datasetStroke: true,
                  //Number - Pixel width of dataset stroke
                  datasetStrokeWidth: 4,
                  //Boolean - Whether to fill the dataset with a color
                  datasetFill: true,
                  //String - A legend template
                  legendTemplate: "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].lineColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>",
                  //Boolean - whether to maintain the starting aspect ratio or not when responsive, if set to false, will take up entire container
                  maintainAspectRatio: true,
                  //Boolean - whether to make the chart responsive to window resizing
                  responsive: true
                };
                
                
                //-------------
                //- Loans Released CHART -
                //--------------
                
                // Get context with jQuery - using jQuery's .get() method.
                var loanChartCanvas = $("#loanReleasedChart").get(0).getContext("2d");
                // This will get the first returned node in the jQuery collection.
                var loanChart = new Chart(loanChartCanvas);
        
                var loanChartData = {
                  labels: ["7th","8th","9th","10th","11th","12th","13th","14th","15th","16th","17th","18th","19th","20th","21st","22nd","23rd","24th","25th","26th","27th","28th","29th","30th","31st"],
                  datasets: [
                    {
                      label: "Loans Released",
                      fillColor: "rgba(210, 214, 222, 1)",
                      strokeColor: "rgba(215,  40, 40, 0.9)",
                      pointColor: "#D72828",
                      pointStrokeColor: "#c1c7d1",
                      pointHighlightFill: "#fff",
                      pointHighlightStroke: "rgba(220,220,220,1)",
                      data: [0,0,0,0,0,0,0,25000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
                    },
                    {}
                  ]
                };
        
                
                //Create the line chart
                var loanChartOptions = areaChartOptions;
                loanChartOptions.datasetFill = false;
                loanChart.Line(loanChartData, loanChartOptions);
        
                //-------------
                //- Loans Collected CHART -
                //--------------
                
                // Get context with jQuery - using jQuery's .get() method.
                var loanChartCanvas = $("#loanCollectedChart").get(0).getContext("2d");
                // This will get the first returned node in the jQuery collection.
                var loanChart = new Chart(loanChartCanvas);
        
                var loanChartData = {
                  labels: ["7th","8th","9th","10th","11th","12th","13th","14th","15th","16th","17th","18th","19th","20th","21st","22nd","23rd","24th","25th","26th","27th","28th","29th","30th","31st"],
                  datasets: [
                    {
                      label: "Loans Collected",
                      fillColor: "rgba(60,141,188,0.9)",
                      strokeColor: "rgba(60,141,188,0.8)",
                      pointColor: "#3C8DBC",
                      pointStrokeColor: "rgba(60,141,188,1)",
                      pointHighlightFill: "#fff",
                      pointHighlightStroke: "rgba(60,141,188,1)",
                      data: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
                    },
                    {}
                  ]
                };
        
                //Create the line chart
                var loanChartOptions = areaChartOptions;
                loanChartOptions.datasetFill = false;
                loanChart.Line(loanChartData, loanChartOptions);

                    
                //-------------
                //- Num Loans Released CHART -
                //--------------
                var Data = {
                  labels: ["7th","8th","9th","10th","11th","12th","13th","14th","15th","16th","17th","18th","19th","20th","21st","22nd","23rd","24th","25th","26th","27th","28th","29th","30th","31st"],
                  datasets: [
                    
                    {
                      label: "Number of Loans Released - Monthly",
                      fillColor: "rgba(60,141,188,0.9)",
                      strokeColor: "rgba(60,141,188,0.8)",
                      pointColor: "#3C8DBC",
                      pointStrokeColor: "rgba(60,141,188,1)",
                      pointHighlightFill: "#fff",
                      pointHighlightStroke: "rgba(60,141,188,1)",
                      data: [0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
                    }
                  ]
                };
                
                var barChartCanvas = $("#numLoansReleasedChart").get(0).getContext("2d");
                var barChart = new Chart(barChartCanvas);
                var barChartData = Data;
                barChartData.datasets[0].fillColor = "#D72828";
                barChartData.datasets[0].strokeColor = "#D72828";
                barChartData.datasets[0].pointColor = "#000";
                var barChartOptions = {
                  //Boolean - Whether the scale should start at zero, or an order of magnitude down from the lowest value
                  scaleBeginAtZero: true,
                  //Boolean - Whether grid lines are shown across the chart
                  scaleShowGridLines: true,
                  //String - Colour of the grid lines
                  scaleGridLineColor: "rgba(0,0,0,.05)",
                  //Number - Width of the grid lines
                  scaleGridLineWidth: 1,
                  //Boolean - Whether to show horizontal lines (except X axis)
                  scaleShowHorizontalLines: true,
                  //Boolean - Whether to show vertical lines (except Y axis)
                  scaleShowVerticalLines: true,
                  //Boolean - If there is a stroke on each bar
                  barShowStroke: true,
                  //Number - Pixel width of the bar stroke
                  barStrokeWidth: 2,
                  //Number - Spacing between each of the X value sets
                  barValueSpacing: 5,
                  //Number - Spacing between data sets within X values
                  barDatasetSpacing: 1,
                  //String - A legend template
                  legendTemplate: "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].fillColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>",
                  //Boolean - whether to make the chart responsive
                  responsive: true,
                  maintainAspectRatio: true
                };
            
                barChartOptions.datasetFill = false;
                barChart.Bar(barChartData, barChartOptions);
                                        
                                        
                //-------------
                //- Num Repayments Collected CHART -
                //--------------
                var Data = {
                  labels: ["7th","8th","9th","10th","11th","12th","13th","14th","15th","16th","17th","18th","19th","20th","21st","22nd","23rd","24th","25th","26th","27th","28th","29th","30th","31st"],
                  datasets: [
                    
                    {
                      label: "Number of Repayments Collected",
                      fillColor: "rgba(210, 214, 222, 1)",
                      strokeColor: "rgba(210, 214, 222, 1)",
                      pointColor: "rgba(210, 214, 222, 1)",
                      pointStrokeColor: "#c1c7d1",
                      pointHighlightFill: "#fff",
                      pointHighlightStroke: "rgba(220,220,220,1)",
                      data: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
                    }
                  ]
                };
                
                var barChartCanvas = $("#numRepaymentsCollectedChart").get(0).getContext("2d");
                var barChart = new Chart(barChartCanvas);
                var barChartData = Data;
                barChartData.datasets[0].fillColor = "#3C8DBC";
                barChartData.datasets[0].strokeColor = "#3C8DBC";
                barChartData.datasets[0].pointColor = "#000";
                var barChartOptions = {
                  //Boolean - Whether the scale should start at zero, or an order of magnitude down from the lowest value
                  scaleBeginAtZero: true,
                  //Boolean - Whether grid lines are shown across the chart
                  scaleShowGridLines: true,
                  //String - Colour of the grid lines
                  scaleGridLineColor: "rgba(0,0,0,.05)",
                  //Number - Width of the grid lines
                  scaleGridLineWidth: 1,
                  //Boolean - Whether to show horizontal lines (except X axis)
                  scaleShowHorizontalLines: true,
                  //Boolean - Whether to show vertical lines (except Y axis)
                  scaleShowVerticalLines: true,
                  //Boolean - If there is a stroke on each bar
                  barShowStroke: true,
                  //Number - Pixel width of the bar stroke
                  barStrokeWidth: 2,
                  //Number - Spacing between each of the X value sets
                  barValueSpacing: 5,
                  //Number - Spacing between data sets within X values
                  barDatasetSpacing: 1,
                  //String - A legend template
                  legendTemplate: "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].fillColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>",
                  //Boolean - whether to make the chart responsive
                  responsive: true,
                  maintainAspectRatio: true
                };
            
                barChartOptions.datasetFill = false;
                barChart.Bar(barChartData, barChartOptions);
                
                
                //-------------
                //- Num Loans Fully paid Collected CHART -
                //--------------
                var Data = {
                  labels: ["7th","8th","9th","10th","11th","12th","13th","14th","15th","16th","17th","18th","19th","20th","21st","22nd","23rd","24th","25th","26th","27th","28th","29th","30th","31st"],
                  datasets: [
                    
                    {
                      label: "Number of Fully Paid Loans",
                      fillColor: "rgba(210, 214, 222, 1)",
                      strokeColor: "rgba(210, 214, 222, 1)",
                      pointColor: "rgba(210, 214, 222, 1)",
                      pointStrokeColor: "#c1c7d1",
                      pointHighlightFill: "#fff",
                      pointHighlightStroke: "rgba(220,220,220,1)",
                      data: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
                    }
                  ]
                };
                
                var barChartCanvas = $("#numLoansFullyPaidCollectedChart").get(0).getContext("2d");
                var barChart = new Chart(barChartCanvas);
                var barChartData = Data;
                barChartData.datasets[0].fillColor = "#00a65a";
                barChartData.datasets[0].strokeColor = "#00a65a";
                barChartData.datasets[0].pointColor = "#000";
                var barChartOptions = {
                  //Boolean - Whether the scale should start at zero, or an order of magnitude down from the lowest value
                  scaleBeginAtZero: true,
                  //Boolean - Whether grid lines are shown across the chart
                  scaleShowGridLines: true,
                  //String - Colour of the grid lines
                  scaleGridLineColor: "rgba(0,0,0,.05)",
                  //Number - Width of the grid lines
                  scaleGridLineWidth: 1,
                  //Boolean - Whether to show horizontal lines (except X axis)
                  scaleShowHorizontalLines: true,
                  //Boolean - Whether to show vertical lines (except Y axis)
                  scaleShowVerticalLines: true,
                  //Boolean - If there is a stroke on each bar
                  barShowStroke: true,
                  //Number - Pixel width of the bar stroke
                  barStrokeWidth: 2,
                  //Number - Spacing between each of the X value sets
                  barValueSpacing: 5,
                  //Number - Spacing between data sets within X values
                  barDatasetSpacing: 1,
                  //String - A legend template
                  legendTemplate: "<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].fillColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>",
                  //Boolean - whether to make the chart responsive
                  responsive: true,
                  maintainAspectRatio: true
                };
            
                barChartOptions.datasetFill = false;
                barChart.Bar(barChartData, barChartOptions);
            
                //-------------
                //- PIE CHART -
                //-------------
                
                  var pieOptions = {
                  //Boolean - Whether we should show a stroke on each segment
                  segmentShowStroke: true,
                  //String - The colour of each segment stroke
                  segmentStrokeColor: "#fff",
                  //Number - The width of each segment stroke
                  segmentStrokeWidth: 2,
                  //Number - The percentage of the chart that we cut out of the middle
                  percentageInnerCutout: 50, // This is 0 for Pie charts
                  //Number - Amount of animation steps
                  animationSteps: 50,
                  //String - Animation easing effect
                  animationEasing: "easeOutBounce",
                  //Boolean - Whether we animate the rotation of the Doughnut
                  animateRotate: true,
                  //Boolean - Whether we animate scaling the Doughnut from the centre
                  animateScale: false,
                  //Boolean - whether to make the chart responsive to window resizing
                  responsive: true,
                  // Boolean - whether to maintain the starting aspect ratio or not when responsive, if set to false, will take up entire container
                  maintainAspectRatio: true,
                  //String - A legend template
                  legendTemplate: "<ul><li>Werewrew</li></ul>"
                };
                
                //-------------
                //- GENDER CHART -
                //-------------
                // Get context with jQuery - using jQuery's .get() method.
                var pieChartCanvas = $("#genderChart").get(0).getContext("2d");
                var pieChart = new Chart(pieChartCanvas);
                var PieData = [
                  {
                    value: 100,
                    color: "#00B4F0",
                    highlight: "#00B4F0",
                    label: "Male %"
                  },
                  {
                    value: 0,
                    color: "#FF17E4",
                    highlight: "#FF17E4",
                    label: "Female %"
                  }
                ];
            
                //Create pie or douhnut chart
                // You can switch between pie and douhnut using the method below.
                pieChart.Doughnut(PieData, pieOptions);
                
                 //-------------
                //- Open Loan Composition -
                //-------------
                // Get context with jQuery - using jQuery's .get() method.
                var pieChartCanvas = $("#openLoansStatusChart").get(0).getContext("2d");
                var pieChart = new Chart(pieChartCanvas);
                var PieData = [
                  {
                    value: 1,
                    color: "#00DB1A",
                    highlight: "#00DB1A",
                    label: "Loans on Schedule"
                  },
                  {
                    value: 0,
                    color: "#D4DB00",
                    highlight: "#D4DB00",
                    label: "Loans with Missed Repayments"
                  },
                  {
                    value: 0,
                    color: "#DB0000",
                    highlight: "#DB0000",
                    label: "Loans Past Maturity"
                  }
                ];
            
                pieChart.Doughnut(PieData, pieOptions);
        
              });

            </script>