<?php
  function ordinal($number) {
      $ends = array('th','st','nd','rd','th','th','th','th','th','th');
      if ((($number % 100) >= 11) && (($number%100) <= 13))
          return $number. 'th';
      else
          return $number. $ends[$number % 10];
  }
?>

<section class="content-header"><h1>Add Expense</h1></section>
  
  <section class="content">               
      <form action="#" class="form-horizontal" method="post" enctype="multipart/form-data" name="frm_add_expense" id="frm_add_expense">
            <div class="box box-info">     
                <div class="box-body">
                    <div class="panel panel-default"><div class="panel-body bg-gray text-bold">Required Fields:</div></div>

                    <div class="form-group">
                        <label for="inputExpenseTypeId" class="col-sm-3 control-label">Expense Type</label>
                        <div class="col-sm-5">
                            <select class="form-control" name="expense_account" id="expense_account">
                                <option value="">Select An Expense</option>
                                <?php foreach ($expenses as $e) { ?>
                                  <option value="<?php echo $e->code;?>"><?php echo $e->description;?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div> 

                    <div class="form-group">
                        <label for="inputExpenseTypeId" class="col-sm-3 control-label">Expense Control/Cash/Bank Account</label>
                        <div class="col-sm-5">
                            <select class="form-control" name="control_account" id="control_account">
                                <option value="">Select An Expense</option>
                                <?php foreach ($accounts as $a) { ?>
                                  <option value="<?php echo $a->code;?>"><?php echo $a->description;?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                  
                    <div class="form-group">
                        <label for="branch" class="col-sm-3 control-label">Branch</label>                      
                        <div class="col-sm-6">
                            <select id="branch" class="form-control" name="branch" >
                                <option value=""></option>
                                <?php foreach ($branches as $b) {?>
                                    <option value="<?php echo $b->code;?>"><?php echo $b->name;?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>

                  <div class="form-group">
                      <label for="borrower" class="col-sm-3 control-label">Staff</label>                      
                      <div class="col-sm-6">
                          <select id="officer" class="form-control" name="officer" >
                              <option value=""></option>
                              <?php foreach ($officers as $l) {?> ,
                                  <option value="<?php echo $l->username;?>"><?php echo $l->fullname;?></option>
                              <?php } ?>
                          </select>
                      </div>
                  </div>

                    <div class="form-group">
                        
                        <label for="inputExpenseAmount" class="col-sm-3 control-label">Expense Amount</label>                      
                        <div class="col-sm-9">
                        <input type="text" name="expense_amount" class="form-control decimal-2-places" id="expense_amount" placeholder="Number or decimal only" value="" required="">
                        </div>
                      
                    </div>

                    <div class="form-group">
                    
                        <label for="inputExpenseDate" class="col-sm-3 control-label">Expense Date</label>                      
                        <div class="col-sm-9">
                            <input type="text" name="expense_date" class="form-control is-datepick" id="expense_date" placeholder="yyyy-mm-dd" value="" required="">
                        </div>
                  
                    </div>
                    <div class="panel panel-default"><div class="panel-body bg-gray text-bold">Optional Fields:</div></div>
                    <div class="form-group">
                        <label for="inputRecurring" class="col-sm-3 control-label">Is  Expense Recurring?</label>   
                        <div class="col-sm-9">
                            <div class="radio">
                                <label>
                                  <input type="radio" name="expense_recurring" id="inputExpenseRecurringNo" value="0" onclick="enableDisableRecurringPeriod()" checked=""> No
                                    
                                </label>
                                &nbsp;&nbsp;&nbsp;&nbsp;
                                <label>
                                  <input type="radio" name="expense_recurring" id="inputExpenseRecurringYes" value="1" onclick="enableDisableRecurringPeriod()"> Yes
                                </label>
                            </div>
                            If you select Yes, then the Expense will be automatically added by system every month.
                        </div>
                    </div>
                    <div class="form-group">
                      
                        <label for="inputRecurringPeriod" class="col-sm-3 control-label">Add Recurring Expense Day</label>
                        <div class="col-sm-5">
                            <select class="form-control" name="expense_recurring_period" id="expense_recurring_period">
                                <option value="0" selected=""></option>
                                <?php for($i=1;$i<32;$i++) { ?>
                                    <option value="<?php echo $i;?>"><?php echo ordinal($i);?></option>
                                <?php } ?>
                                <option value="32">
                                    End  of every month
                                </option>
                            </select>
                        </div> 
                    </div> 
                    <hr> 
                                      
                    <div class="form-group">
                        <label for="inputExpenseDescription" class="col-sm-3 control-label">Description</label>                      
                        <div class="col-sm-9">
                            <textarea name="expense_description" class="form-control" id="expense_description" rows="3"></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                    
                        <label for="expense_files" class="col-sm-3 control-label">Invoice/Receipt<br>(text, word, pdf, image, zip, csv, or excel)</label>
                        <div class="col-sm-9">    
                            <input type="file" id="data_files" name="expense_files[]" multiple="">
                        </div>
                        <div class="col-sm-9">
                            You can select up to 20 files. Please click <b>Browse</b> button and then hold <b>Ctrl</b> button on your keyboard to select multiple files.
                        </div>
                        
                    </div>

<!--                 <p style="text-align:center; font-weight:bold;"><small><a href="<?php echo base_url();?>/admin/view_custom_fields.php" target="_blank">Click here to add custom fields on this page</a></small></p>
 -->
                </div>
              
                <div class="box-footer">
<!--                     <button type="button" class="btn btn-default" onclick="parent.location='<?php echo base_url();?>/expenses/view_expenses_branch.php'">Back</button>
 -->                    
                      <label for="LabelSavingReceipt" class="col-sm-3 control-label"></label>                      
                      <button 
                          type="submit" 
                          class="btn btn-info pull-left col-sm-3" 
                          data-loading-text="<i class='fa fa-spinner fa-spin '></i> Please Wait"
                          id="btn_add_expense">Submit
                      </button>
                    
                </div>
            </div>
        </form>

</section>



<script>
    $(function() {

        $('#btn_add_expense').on('click',function(e){
            e.preventDefault();
            if (validated()) {
                if (confirm('Add Expense')) {
                    $(document.body).css({'cursor' : 'progress'});
                    var expense = $("#frm_add_expense").serialize();
                    var url = '<?php echo base_url();?>save_expense';
                    $.post(url,{expense:expense},function(o_data,status){
                        alert(o_data);
                        $(document.body).css({'cursor' : 'default'});
                        clear_data();
                    });
                } 
            }
        });

        function clear_data()
        {
            document.forms["frm_add_expense"]["expense_account"].value = '';
            document.forms["frm_add_expense"]["control_account"].value = '';
            document.forms["frm_add_expense"]["expense_amount"].value = '';
            document.forms["frm_add_expense"]["expense_date"].value = '';
            document.forms["frm_add_expense"]["expense_description"].value = '';
            document.forms["frm_add_expense"]["officer"].value = '';
            document.forms["frm_add_expense"]["branch"].value = '';

        }

        function validated()
        {
            var x = document.forms["frm_add_expense"]["expense_account"].value;

            if (x == "") {
                alert("Expense account must be filled out");
                document.forms["frm_add_expense"]["expense_account"].focus();
                return false;
            }

            x = document.forms["frm_add_expense"]["control_account"].value;
            if (x == "") {
                alert("Control account must be filled out");
                document.forms["frm_add_expense"]["control_account"].focus();
                return false;
            }

            x = document.forms["frm_add_expense"]["expense_amount"].value;
            if (x == "") {
                alert("Amount must be filled out");
                document.forms["frm_add_expense"]["expense_amount"].focus();
                return false;
            }

            x = document.forms["frm_add_expense"]["expense_date"].value;
            if (x == "") {
                alert("Date must be filled out");
                document.forms["frm_add_expense"]["expense_date"].focus();
                return false;
            }

            x = document.forms["frm_add_expense"]["expense_description"].value;
            if (x == "") {
                alert("Description must be filled out");
                document.forms["frm_add_expense"]["expense_description"].focus();
                return false;
            }

            x = document.forms["frm_add_expense"]["branch"].value;
            if (x == "") {
                alert("Branch must be filled out");
                document.forms["frm_add_expense"]["branch"].focus();
                return false;
            }

            x = document.forms["frm_add_expense"]["officer"].value;
            if (x == "") {
                alert("Staff must be filled out");
                document.forms["frm_add_expense"]["officer"].focus();
                return false;
            }

            return true;
        }

    });

</script>

            