<?php
    if ($borrower == 'undefined') {$borrower = '';}
?>

<div>
        <form  class="form-horizontal" enctype="multipart/form-data" id="frm_loan_repayment">
            <div class="box-body">

                <div class="form-group"> 
                    <label for="borrower" class="col-sm-3 control-label">Borrower ID #</label>                      
                    <div class="col-sm-3">
                        <input 
                            type="text" 
                            name="borrower_id" 
                            class="form-control" 
                            id="borrower_id" 
                            placeholder="" 
                            value="<?php echo $borrower; ?>"
                        >
                    </div>
                    <div class="col-sm-3">
                        <label>Click [ENTER] to search using ID</label>
                    </div>
                </div>

                <div class="form-group">
                    <label for="borrower" class="col-sm-3 control-label">Borrower</label>                      
                    <div class="col-sm-6">
                        <select id="borrower" class="form-control" name="borrower" >
                            <option value=""></option>
                            <?php foreach ($clients as $c) {?>
                                <option value="<?php echo $c->code;?>"><?php echo $c->name;?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label for="borrower" class="col-sm-3 control-label">Loan Officer</label>                      
                    <div class="col-sm-6">
                        <select id="loan_officer" class="form-control" name="loan_officer" >
                            <option value=""></option>
                            <?php foreach ($loan_officers as $l) {?>
                                <option value="<?php echo $l->code;?>"><?php echo $l->name;?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label for="branch" class="col-sm-3 control-label">Branch</label>                      
                    <div class="col-sm-6">
                        <select id="branch" class="form-control" name="branch" >
                            <option value=""></option>
                            <?php foreach ($branches as $b) {?>
                                <option value="<?php echo $b->code;?>"><?php echo $b->name;?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label for="loan_amount" class="col-sm-3 control-label">Loan Amount Due</label>                      
                    <div class="col-sm-3">
                        <input type="text" name="loan_amount" class="form-control" id="loan_amount" value="0" readonly="readonly">
                    </div>
                </div>

                <div class="form-group">
                    <label for="repayment" class="col-sm-3 control-label">Repayment Amount</label>                      
                    <div class="col-sm-3">
                        <input type="text" name="repayment" class="form-control" id="repayment" placeholder="" value="0">
                    </div>
                </div>

                <div class="form-group">
                    <label for="trans_mode" class="col-sm-3 control-label">Transaction Method</label>                      
                    <div class="col-sm-6">
                        <select id="trans_mode" name="trans_mode">
                            <option value="PAYBILL">PAYBILL</option>
                           <option value="BANK">BANK</option>
                            <option value="CASH">CASH</option>
                         </select>
                    </div>
                </div>

                <div class="form-group">
                    <label for="trans_ref" class="col-sm-3 control-label">Payment Reference(MPESA Code)</label>                      
                    <div class="col-sm-3">
                        <input type="text" name="trans_ref" class="form-control" id="trans_ref" value="">
                    </div>
                </div>

                <div class="form-group">
                    <label for="pay_date" class="col-sm-3 control-label">Date</label>                      
                    <div class="col-sm-3">
                        <input type="date" name="pay_date" class="form-control" id="pay_date" value="<?php echo date('Y-m-d');?>">
                    </div>
                </div>


                <div class="box-footer">
                    <label for="subMitLoanRepayment" class="col-sm-3 control-label"></label>                      
                    <button id="subMitLoanRepayment" class="btn btn-success pull-left col-sm-3">Add</button>
                    
                </div><!-- /.box-footer -->
            </div>        
        </form>


    </div>


<script>
    $(function() {

        if ( $('#borrower_id').val() != "") {
            var borrower = $('#borrower_id').val();
            var url = '<?php echo base_url();?>client/getDetails_ID';
            $(document.body).css({'cursor' : 'wait'});
            $.post(url,{client:borrower},function(o_data,status){
                if (o_data == '') {
                    $("#borrower").val('');
                    $("#loan_officer").val('');
                    $("#branch").val('');
                    $("#loan_amount").val('');
                    alert("NO CUSTOMER WITH THIS ID NO!");
                } else {
                    var data = o_data.substring(1, o_data.length-1);
                    var client = JSON.parse(data); 
                    $("#borrower").val(client.code);
                    $("#loan_officer").val(client.loan_officer);
                    $("#branch").val(client.branch);
                    $("#loan_amount").val(client.loan_amt);
                }
                $(document.body).css({'cursor' : 'default'});
            });        
        }

        $('#borrower_id').off('keypress');
        $('#borrower_id').on('keypress',function(e) {
            if (e.which == 13) {
                e.preventDefault();
                getdetails();
            }
        });
        
        $('#subMitLoanRepayment').on('click',function(e){
            e.preventDefault();
            if (validated()) {
                if (confirm('Add Loan Repayment')) {
                    $(document.body).css({'cursor' : 'progress'});
                    var loan = $("#frm_loan_repayment").serialize();
                    var url = '<?php echo base_url();?>add_repayment';
                    $.post(url,{loan:loan},function(o_data,status){
                        alert(o_data);
                        $(document.body).css({'cursor' : 'default'});
                        clear_data();
                    });
                }
            }
        });

        function getdetails()
        {
            var borrower = $('#borrower_id').val();
            var url = '<?php echo base_url();?>client/getDetails_ID';
            $(document.body).css({'cursor' : 'wait'});
            $.post(url,{client:borrower},function(o_data,status){
                if (o_data == '') {
                    $("#borrower").val('');
                    $("#loan_officer").val('');
                    $("#branch").val('');
                    $("#loan_amount").val('');
                    alert("NO CUSTOMER WITH THIS ID NO!");
                } else {
                    var data = o_data.substring(1, o_data.length-1);
                    var client = JSON.parse(data); 
                    $("#borrower").val(client.code);
                    $("#loan_officer").val(client.loan_officer);
                    $("#branch").val(client.branch);
                    $("#loan_amount").val(client.loan_amt);
                }
                $(document.body).css({'cursor' : 'default'});
            });        
        }

        function clear_data()
        {
            document.forms["frm_loan_repayment"]["borrower"].value = '';
            document.forms["frm_loan_repayment"]["loan_officer"].value = '';
            document.forms["frm_loan_repayment"]["branch"].value = '';
            document.forms["frm_loan_repayment"]["repayment"].value = '';
            document.forms["frm_loan_repayment"]["trans_mode"].value = '';
            document.forms["frm_loan_repayment"]["trans_ref"].value = '';
        }

        function validated()
        {
            var x = document.forms["frm_loan_repayment"]["borrower"].value;

            if (x == "") {
                alert("Borrower must be filled out");
                document.forms["frm_loan_repayment"]["borrower"].focus();
                return false;
            }

            x = document.forms["frm_loan_repayment"]["loan_officer"].value;
            if (x == "") {
                alert("Loan Officer must be filled out");
                document.forms["frm_loan_repayment"]["loan_officer"].focus();
                return false;
            }

            x = document.forms["frm_loan_repayment"]["branch"].value;
            if (x == "") {
                alert("Branch must be filled out");
                document.forms["frm_loan_repayment"]["branch"].focus();
                return false;
            }

            x = document.forms["frm_loan_repayment"]["repayment"].value;
            if (x == "") {
                alert("Repayment Amount must be filled out");
                document.forms["frm_loan_repayment"]["repayment"].focus();
                return false;
            }

            x = document.forms["frm_loan_repayment"]["trans_mode"].value;
            if (x == "") {
                alert("Payment Method must be filled out");
                document.forms["frm_loan_repayment"]["trans_mode"].focus();
                return false;
            }

            x = document.forms["frm_loan_repayment"]["trans_ref"].value;
            if (x == "") {
                alert("Payment Reference(MPESA Code) be filled out");
                document.forms["frm_loan_repayment"]["trans_ref"].focus();
                return false;
            }

            x = document.forms["frm_loan_repayment"]["pay_date"].value;
            if (x == "") {
                alert("Payment Date be filled out");
                document.forms["frm_loan_repayment"]["pay_date"].focus();
                return false;
            }

            return true;
        }

        $('#borrower').on('change',function(e){
            e.preventDefault();
            var borrower = $(this).val();
            var url = '<?php echo base_url();?>client/getDetails';
            $(document.body).css({'cursor' : 'wait'});
            $.post(url,{client:borrower},function(o_data,status){
                var data = o_data.substring(1, o_data.length-1);
                var client = JSON.parse(data); 
                $("#loan_officer").val(client.loan_officer);
                $("#branch").val(client.branch);
                $("#loan_amount").val(client.loan_amt);
                $(document.body).css({'cursor' : 'default'});
            });
        });

    });

</script>
