
                <!-- Content Header (Page header) -->
                <section class="content-header"><h1>Microfinance Financial Reporting Standards - Ratios</h1>
                </section>

                <!-- Main content -->
                <section class="content">
        <div class="box box-success">
            <div class="box-header with-border">
              <h3 class="box-title">Date Range</h3>
            </div>
            <form class="form-horizontal" method="get" enctype="multipart/form-data">
                <input type="hidden" name="search" value="1">
                <div class="box-body">
                  <div class="row">
                      <script>
                        $(function() {
                            $('#startPicker,#endPicker').datepick({ 
                                onSelect: customRange, showTrigger: '#calImg', 
                                dateFormat: 'yyyy-mm-dd'}); 
                 
                                function customRange(dates) { 
                                    if (this.id == 'startPicker') { 
                                        $('#endPicker').datepick('option', 'minDate', dates[0] || null); 
                                    } 
                                    else { 
                                        $('#startPicker').datepick('option', 'maxDate', dates[0] || null); 
                                    } 
                                }
                        });
        
                    </script>
                    <div class="col-xs-5">
                        <input type="text" name="start_date" class="form-control is-datepick" id="startPicker" placeholder="From Date" value="06/10/2016" required=""> 
                    </div>
                    <div class="col-xs-1  text-center" style="padding-top: 5px;">
                        to
                    </div>
                    <div class="col-xs-5">
                        <input type="text" name="end_date" class="form-control is-datepick" id="endPicker" placeholder="To Date" value="06/10/2017" required="">
                    </div>
               </div>
          </div>
          <div class="box-body">
               <div class="row">
                    <div class="col-xs-2">
                        <span class="input-group-btn">
                          <button type="submit" class="btn bg-olive btn-flat">Search!</button>
                        </span>
                        <span class="input-group-btn">
                          <button type="button" class="btn bg-purple  btn-flat pull-right" onclick="parent.location='<?php echo base_url();?>/reports/mfrs_ratios.php'">Reset!</button>
                        </span>
                    </div>
                  </div>
                </div><!-- /.box-body -->
            </form>
          </div><!-- /.box -->
    <div class="row row-grid">
        <div id="pre_loader" style="display: none;">
            <div class="loader"></div>
            <div style="text-align:center; font-weight:bold;font-style:italic;">Loading MFRS Ratios. Please wait...</div>
        </div>
    </div>                                                                                                                                                                                                                                                                
        <div class="row">
            <div class="col-md-12">
              <table class="table table-bordered table-hover " style="background: #FFF;">
                <tbody>
                    <tr class="bg-green">
                      <td style="font-weight:bold" colspan="6">PROFITABILITY RATIOS</td>
                    </tr>
                    <tr style="background: #CCC;">
                      <td style="font-weight:bold;">Ratio no.</td>
                      <td style="font-weight:bold">Term</td>                      
                      <td style="font-weight:bold">Value</td>
                      <td style="font-weight:bold">Formula</td>
                      <td style="font-weight:bold">Calculation notes</td>
                      <td style="font-weight:bold">Use</td>
                    </tr>
                    <tr>
                        <td class="text-bold">R1</td>
                        <td>Portfolio yield</td>
                        <td class="text-bold">%</td>
                        <td>Interest, fees, and commissions in loan portfolio/ Average gross loan portfolio</td>
                        <td>MFRS assumes that accrued interest receivable is backed out or reversed if not received.<br><br>
As the ratio is calculated using averaging, it eliminates the effect of seasonal highs and lows.</td>
                        <td>Indicates the MFI’s ability to
generate cash from interest, fees,
and commissions in the average
gross loan portfolio. A decreasing
trend means lower earnings in the
portfolio, either from a change in
product pricing, product portfolio
composition, or foregone revenue
due to rising arrears.</td>
                    </tr>
                    <tr>
                        <td class="text-bold">R6</td>
                        <td>Impairment expense ratio</td>
                        <td class="text-bold">%</td>
                        <td>Impairment expense/ Average gross loan portfolio</td>
                        <td>This ratio can also be measured as a
proportion of NPL30 with NPL30
in the denominator.</td>
                        <td>Measures the impairment expense
as a proportion of the average
gross portfolio, which represents
the cost of credit-related losses or
write-offs in the portfolio. Changes
in this ratio may be due to changes
in delinquency or to provisioning
policies.</td>
                    </tr>
                    <tr>
                        <td class="text-bold">R7</td>
                        <td>Operating expense ratio</td>
                        <td class="text-bold">%</td>
                        <td>Operating expense/ Average gross loan portfolio</td>
                        <td></td>
                        <td>Measures the administrative and
overhead costs incurred to deliver
loans. Declining trend, while a sign
of an MFI’s improving efficiency,
may also reflect a rising average
loan size.</td>
                    </tr>
                    
                </tbody>
              </table>
            </div>
          </div>
    <script>
    $( "#pre_loader" ).hide();
    </script>
    
                    </section>
            