<section class="content-header"><h1>View branches</h1></section>
    <section class="content">
        <div class="box box-info">
            <div class="box-body">
                <div class="col-sm-12 table-responsive">
                      <style>
                        div.container {
                            margin: 0 auto;
                            max-width:80%;
                        }
                        div.header {
                            margin: 100px auto;
                            line-height:10px;
                            max-width:80%;
                        }
                      </style>

                      <table id="branches-grid"  
                        cellpadding="0" 
                        cellspacing="0" 
                        border="0" 
                        class="display w3-table w3-striped w3-bordered w3-border w3-hoverable w3-white" 
                        width="100%"
                      >
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Telephone</th>
                                <th>Loan Officers</th>
                                <th>Loan Accounts</th>
                                <th>Portfolio</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th>#</th>
                                <th>Code</th>
                                <th>Name</th>
                                <th>Telephone</th>
                                <th>Loan Officers</th>
                                <th>Loan Accounts</th>
                                <th>Portfolio</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </tfoot>

                      <tbody>
                    </table>

                     <script type="text/javascript" language="javascript" >
                        $(document).ready(function() {

                          var dataTable = $('#branches-grid').DataTable( {
                            dom: 'lBfrtipl',
                            buttons: [
                              {
                                text: 'New Branch',
                                action: function ( e, dt, node, config ) {
                                var url = '<?php echo base_url()?>new_branch';
                                load_page(url);
                                }
                              }
                            ],
                            "processing": true,
                            "serverSide": true,
                            "ajax":{
                              url :"<?php echo site_url();?>settings/branches_list_",
                              type: "post", 
                              data : { "status" : ""},  
                              error: function(xhr,status,error){
                                alert(xhr.responseText);
                                $(".employee-grid-error").html("");
                                $("#branches-grid").append('<tbody class="employee-grid-error"><tr><th colspan="3">No data found in the server</th></tr></tbody>');
                                $("#employee-grid_processing").css("display","none");
                              }
                            }
                          });

                        });
                      </script>


                </div>
                </div>
            </div>
        </div>

    </section>

    
    <script type="text/javascript">
       $(document).off('click','#view_branch');
       $(document).on('click','#view_branch',function (e) {
            var id = $(this).attr('idx');
            $( "#datashow" ).load("<?php echo base_url()?>view_branch",{id:id}, function() {});
        });

       $(document).off('click','#edit_branch');
       $(document).on('click','#edit_branch',function (e) {
            var id = $(this).attr('idx');
            $( "#datashow" ).load("<?php echo base_url()?>edit_branch",{id:id}, function() {});
        });


       $(document).off('click','#delete_branch');
       $(document).on('click','#delete_branch',function (e) {

            if (confirm("Delete branch ?")) {
              var id = $(this).attr('idx');
              var url = '<?php echo base_url();?>settings/delete_branch';
              $.post(url,{id:id},function(o_data,status){
                  alert(o_data);
                  $("#datashow").load("<?php echo base_url()?>branches",{}, function() {});
              });
            }

        });

    </script>