<?php
defined('BASEPATH') OR exit('No direct script access allowed');
#require_once __DIR__ . '../../vendor/autoload.php';

class User extends CI_Controller {

	public function __construct()
    {
        parent::__construct();


        if (!$this->session->userdata('logged_in')) {
            redirect('/login');
        }
    }

    public function index()
    {
        $data['module'] = __FUNCTION__;
        $this->load->view('admin/users/users',$data);
    }

    public function add_user()
    {
        $data['module'] = 'add_user'; 
        $this->load->view('admin/users/add',$data);
    }

    public function create_user()
    {
        $user = $this->input->post('user');
        echo $this->Users_Model->create_user($user);
    }

    public function edit_user()
    {
        $id = $this->input->post('id');
        $code = $this->input->post('code');

        $data = $this->data('ALLALL','ALL');
        $data['module'] = 'add_user';
        $data['user'] = $this->Users_Model->get_user($id,0,$code);
        $this->load->view('admin/users/edit',$data);
    }

    public function view_user()
    {
        $id = $this->input->post('id');
        $code = $this->input->post('code');

        $data = $this->data();
        $data['module'] = 'view_user';
        $data['user'] = $this->Users_Model->get_user($this->input->post('id'));
        $this->load->view('admin/users/view_user',$data);
    }

    public function update_user()
    {
        $user = $this->input->post('user');
        echo $this->Users_Model->update_user($user);
    }

    public function users_list()
    {
        function actions($q) {
             $chek = '
                <div class="dropdown">
                    <button class="btn btn-warning dropdown-toggle" type="button" data-toggle="dropdown">Actions
                    <span class="caret"></span></button>
                    <ul class="dropdown-menu">
                      <li><a href="#"class="list_actions" module="users" 
                      idx="'.$q->id.'" code="'.$q->code.'" action="update">Update</a></li>
                      <li class="divider"></li>
                      <li><a href="#"class="list_actions" module="users" 
                      idx="'.$q->id.'" code="'.$q->code.'" action="view">View</a></li>
                    </ul>
                  </div>
            ';

            return $chek;                    

        }
 
        function audit_log($code,$id) {
            return $code.'&nbsp;&nbsp;<a class="fa fa-copy list_actions" module="users" action="audit_trail" code="'.$code.'" idx="'.$id.'" href="#"></a>';
        }

        function active($q) {
            if (strtoupper($q->status) == '1') {
                return 'YES<a class="fa fa-remove list_actions" style="color:red;padding-left:20px;" action="deactivate" idx="'.$q->id.'" href="#"></a>';
            } else {
                return 'NO<a class="fa fa-plus list_actions" style="color:green;padding-left:20px;" action="activate" idx="'.$q->id.'" href="#"></a>';
            }
        }

        $requestData = $_REQUEST;

        $query = $this->Users_Model->user_list($requestData,$totalData,$totalFiltered);

        $data = array();
        foreach ($query as $q) {
            $nestedData = array(); 

            $nestedData[] = $q->id;
            $nestedData[] = $q->code;
            $nestedData[] = $q->name;
            $nestedData[] = active($q);
            $nestedData[] = $q->last_passwd_change;
            $nestedData[] = actions($q);
            
            $data[] = $nestedData;
        }

        $json_data = array(
            "draw"            => intval( $requestData['draw'] ),   
            "recordsTotal"    => intval( $totalData ),  
            "recordsFiltered" => intval( $totalFiltered ),
            "data"            => $data   
        );

        echo json_encode($json_data);
    }

    public function approve_userr()
    {
        $user = $this->input->post('user');
        echo $this->Users_Model->approve_user($user);
    }

    public function activate_user()
    {
        $id = $this->input->post('id');
        echo $this->Users_Model->activate_user($id);
    }

    public function deactivate_user()
    {
        $id = $this->input->post('id');
        echo $this->Users_Model->deactivate_user($id);
    }

}
