<?php
class Dashboard_Model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
        $this->init();
    }

    function init()
    {
    }
 
    function summary()
    {
        $staff = $this->session->userdata('usercode');

        $q = "
            select sum(TransAmount)one 
            from mpesa_payments where MSISDN <> '' 
            and left(TransTime,8)=concat(year(current_date),lpad(month(current_date),2,0),lpad(day(current_date),2,0))  
        ";
        $receipts = $this->db->query($q)->row()->one;

        $q = "
            select count(TransAmount)one 
            from mpesa_payments where MSISDN <> '' 
            and left(TransTime,8)=concat(year(current_date),lpad(month(current_date),2,0),lpad(day(current_date),2,0))  
        ";
        $count = $this->db->query($q)->row()->one;

        $q = "
            select sum(TransAmount)one 
            from mpesa_payments where MSISDN = '' 
            and left(TransTime,8)=concat(year(current_date),lpad(month(current_date),2,0),lpad(day(current_date),2,0))  
        ";
        $transfers = $this->db->query($q)->row()->one;

        $q = "
            select count(TransAmount)one 
            from mpesa_payments where MSISDN = '' 
            and left(TransTime,8)=concat(year(current_date),lpad(month(current_date),2,0),lpad(day(current_date),2,0))  
        ";
        $t_count = $this->db->query($q)->row()->one;

        $summary = array(
            'receipts'=>$receipts,
            'count'=>$count,
            'transfers'=>$transfers,
            't_count'=>$t_count,

        );
        return $summary;  
    }

    function receipts()
    {
        $q = "select * from mpesa_payments where MSISDN <> '' order by 1 desc limit 10";
        return $this->db->query($q)->result();
    }

    function transfers()
    {
        $q = "select * from mpesa_payments where MSISDN = '' order by 1 desc limit 10";
        return $this->db->query($q)->result();
    }

    function tillnumbers()
    {
        $q = "select distinct BusinessShortCode code from mpesa_payments";
        return $this->db->query($q)->result();
    }

    function receipts_list($requestData,&$totalData,&$totalFiltered,&$total) 
    { 
        $table = 'mpesa_payments';

        $dfrom = $requestData['dfrom'];
        $dto = $requestData['dto'];
        $tillnumber = $requestData['tillnumber'];
        $module = $requestData['module'];

        $dfrom = implode("-", array_reverse(explode("-", $dfrom)));
        $dto = implode("-", array_reverse(explode("-", $dto)));

        $columns = array( 
            0 => 'id', 
            1 => 'TransactionType',
            2 => 'TransID',
            3 => 'TransTime',
            4 => 'TransAmount',
            5 => 'BusinessShortCode',
            6 => 'MSISDN',
            7 => 'First_Name',
            8 => 'Middle_Name',
            9 => 'Last_Name',
            10 => 'OrgAccountBalance',
       );

        $q = "select ifnull(sum(TransAmount),0) total from $table where MSISDN <> '' and dt(TransTime) between '$dfrom' and '$dto' ";
        if($tillnumber != "ALL") $q .= " and BusinessShortCode = '$tillnumber' ";
        $total = $this->db->query($q)->row()->total;

        $sql = "SELECT @id:=@id+1 as id,".
                $columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".
                $columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].",".
                $columns[10].
        " FROM ".$table." where MSISDN <> '' and dt(TransTime) between '$dfrom' and '$dto' ";

        if($tillnumber != "ALL") $sql .= " and BusinessShortCode = '$tillnumber' ";
        #if($user != "ALL") $sql .= " and staff = '$user' ";
        
        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[7]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[8]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();
    } 

    function transfers_list($requestData,&$totalData,&$totalFiltered,&$total) 
    { 
        $table = 'mpesa_payments';

        $dfrom = $requestData['dfrom'];
        $dto = $requestData['dto'];
        $tillnumber = $requestData['tillnumber'];
        $module = $requestData['module'];

        $dfrom = implode("-", array_reverse(explode("-", $dfrom)));
        $dto = implode("-", array_reverse(explode("-", $dto)));

        $columns = array( 
            0 => 'id', 
            1 => 'TransactionType',
            2 => 'TransID',
            3 => 'TransTime',
            4 => 'TransAmount',
            5 => 'BusinessShortCode',
            6 => 'MSISDN',
            7 => 'First_Name',
            8 => 'Middle_Name',
            9 => 'Last_Name',
            10 => 'OrgAccountBalance',
       );

        $q = "select ifnull(sum(TransAmount),0) total from $table where MSISDN = '' and dt(TransTime) between '$dfrom' and '$dto' ";
        if($tillnumber != "ALL") $q .= " and BusinessShortCode = '$tillnumber' ";
        $total = $this->db->query($q)->row()->total;

        $sql = "SELECT @id:=@id+1 as id,".
                $columns[0].", ".$columns[1].", ".$columns[2].", ".$columns[3].", ".$columns[4].", ".
                $columns[5].", ".$columns[6].", ".$columns[7].", ".$columns[8].", ".$columns[9].",".
                $columns[10].
        " FROM ".$table." where MSISDN = '' and dt(TransTime) between '$dfrom' and '$dto' ";

        if($tillnumber != "ALL") $sql .= " and BusinessShortCode = '$tillnumber' ";
        #if($user != "ALL") $sql .= " and staff = '$user' ";
        
        $query = $this->db->query($sql);
        $totalData = $query->num_rows();
        $totalFiltered = $totalData;  

        if( !empty($requestData['search']['value']) ) {   
            $sql.=" AND ( ".$columns[0]." LIKE '%".$requestData['search']['value']."%' ";    
            $sql.=" OR ".$columns[1]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[2]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[3]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[4]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[5]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[6]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[7]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.=" OR ".$columns[8]." LIKE '%".$requestData['search']['value']."%' ";
            $sql.= ") ";
        }

        $query = $this->db->query($sql);
        $totalFiltered = $query->num_rows();

        $sql.=" ORDER BY ". $columns[$requestData['order'][0]['column']]."   ".$requestData['order'][0]['dir']."  
                LIMIT ".$requestData['start']." ,".$requestData['length']."   ";

        $this->db->query("set @id=0");
        $query = $this->db->query($sql);

        return $query->result();
    } 

    function today_receipts($excel=0)
    {
        $q = "
            select *
            from mpesa_payments where MSISDN <> '' 
            and left(TransTime,8)=concat(year(current_date),lpad(month(current_date),2,0),lpad(day(current_date),2,0))  
            order by 1
        ";
        if ($excel == 1) {
            $this->load->dbutil();
            $delimiter = ",";
            $newline = "\n";                
            $report['data'] = $this->dbutil->csv_from_result($this->db->query($q),$delimiter,$newline);
        } else {
            $report['data'] = $this->db->query($q)->result();
        }
        return $report;
    }

    function today_summary($excel=0)
    {
        $q = "
            select BusinessShortCode,sum(TransAmount)TransAmount
            from mpesa_payments where MSISDN <> '' 
            and left(TransTime,8)=concat(year(current_date),lpad(month(current_date),2,0),lpad(day(current_date),2,0))  
            group by 1 order by 1
        ";
        if ($excel == 1) {
            $this->load->dbutil();
            $delimiter = ",";
            $newline = "\n";                
            $report['data'] = $this->dbutil->csv_from_result($this->db->query($q),$delimiter,$newline);
        } else {
            $report['data'] = $this->db->query($q)->result();
        }
        return $report;
    }

    function rpt($data,$excel=0)
    {
        $data = ($data[0]=='"'?substr($data, 1, -1):$data);
        parse_str($data,$data);
        $staff = $this->session->userdata('username');

        $tillnumber = isset($data['tillnumber'])?$data['tillnumber']:'ALL';
        $dateFrom = isset($data['dateFrom'])?$data['dateFrom']:date('d-m-Y');
        $dateTo = isset($data['dateTo'])?$data['dateTo']:date('d-m-Y');
        $rptType = isset($data['rptType'])?$data['rptType']:'ALL';

        $dfrom = implode("-", array_reverse(explode("-", $dateFrom)));
        $dto = implode("-", array_reverse(explode("-", $dateTo)));

        if ($rptType=='detailed') {
            $q = "
                select *
                from mpesa_payments where MSISDN <> '' 
                and dt(TransTime) between '$dfrom' and '$dto' 
            ";

            if ($tillnumber!='ALL') $q .= " and BusinessShortCode = '$tillnumber' ";
            $q .= " order by 1";
        } else {
            $q = "
                select BusinessShortCode,sum(TransAmount)TransAmount
                from mpesa_payments where MSISDN <> '' 
                and dt(TransTime) between '$dfrom' and '$dto' 
                
            ";
            if ($tillnumber!='ALL') $q .= " and BusinessShortCode = '$tillnumber' ";
            $q .= " group by 1 order by 1";
        }
        if ($excel == 1) {
            $this->load->dbutil();
            $delimiter = ",";
            $newline = "\n";                
            $report['data'] = $this->dbutil->csv_from_result($this->db->query($q),$delimiter,$newline);
        } else {
            $report['data'] = $this->db->query($q)->result();
        }
        return $report;
    }

    function receipts_($date_from,$date_to,$tillnumber,$excel=0)
    {
        $staff = $this->session->userdata('username');

        $date_from = implode("-", array_reverse(explode("-", $date_from)));
        $date_to = implode("-", array_reverse(explode("-", $date_to)));

        $q = "
            select *
            from mpesa_payments where MSISDN <> '' 
            and dt(TransTime) between '$date_from' and '$date_to' 
        ";

        if ($tillnumber!='ALL') $q .= " and BusinessShortCode = '$tillnumber' ";

        $q .= " order by 1";

        if ($excel == 1) {
            $this->load->dbutil();
            $delimiter = ",";
            $newline = "\n";                
            $report['data'] = $this->dbutil->csv_from_result($this->db->query($q),$delimiter,$newline);
        } else {
            $report['data'] = $this->db->query($q)->result();
        }
        return $report;
    }

    function transfers_($date_from,$date_to,$tillnumber,$excel=0)
    {
        $staff = $this->session->userdata('username');

        $date_from = implode("-", array_reverse(explode("-", $date_from)));
        $date_to = implode("-", array_reverse(explode("-", $date_to)));

        $q = "
            select *
            from mpesa_payments where MSISDN = '' 
            and dt(TransTime) between '$date_from' and '$date_to' 
        ";

        if ($tillnumber!='ALL') $q .= " and BusinessShortCode = '$tillnumber' ";

        $q .= " order by 1";

        if ($excel == 1) {
            $this->load->dbutil();
            $delimiter = ",";
            $newline = "\n";                
            $report['data'] = $this->dbutil->csv_from_result($this->db->query($q),$delimiter,$newline);
        } else {
            $report['data'] = $this->db->query($q)->result();
        }
        return $report;
    }

}              

?>
