<?php 
    $dfrom = date('d-m-Y', strtotime('-1 month')); 
    $dto = date('d-m-Y'); 
?>
<section class="content-header">
    <h1>Users
    &nbsp;&nbsp;&nbsp;<a href="#" class="preview_rpt" id="export_rpt" report_type="PREVIEW" module="<?php echo $module;?>"><i class="fa fa-print"></i></a>
    &nbsp;&nbsp;&nbsp;<a href="#" class="preview_rpt" id="export_excel" report_type="EXCEL" module="<?php echo $module;?>"><i class="fa fa-file-excel-o"></i></a>
    &nbsp;&nbsp;&nbsp;<a href="#" class="preview_rpt" id="export_pdf" report_type="PDF" module="<?php echo $module;?>"><i class="fa fa-file-pdf-o"></i> </a>
     </h1>
</section>

<section class="content">
        <div class="box box-info">
            <div class="box-body">
                <div class="col-sm-12 table-responsive">
                    <div id="view-users_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">

                        <table id="users-grid"  
                            cellpadding="0" 
                            cellspacing="0" 
                            border="0" 
                            class="display w3-table w3-striped w3-bordered w3-border w3-hoverable w3-white" 
                            width="100%"
                          >
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Code</th>
                                    <th>Name</th>
                                    <th>Active</th>
                                    <th>Last Password Change</th>
                                    <th>Actions</th>              
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>Code</th>
                                    <th>Name</th>
                                    <th>Active</th>
                                    <th>Last Password Change</th>
                                    <th>Actions</th>              
                                </tr>
                            </tfoot>

                          <tbody>
                          </tbody>
                      </table>
                    </div>
                </div>
            </div>
        </div>

</section> 

 <script type="text/javascript" language="javascript" >
    $(function() {
       $(".datepicker").datepicker({autoclose:true,format:'dd-mm-yyyy'});

      var dataTable = $('#users-grid').DataTable( {
        "processing": true,
        "serverSide": true,
        "ajax":{
          url :"<?php echo base_url();?>users_list",
          type: "post", 
            data : function(data) {
                data.status  = '<?php echo $module;?>';
            },
          error: function(xhr,status,error){
            alert(xhr.responseText);
            $(".users-grid-error").html("");
            $("#users-grid").append('<tbody class="users-grid-error"><tr><th colspan="3">No data found in the server</th></tr></tbody>');
            $("#users-grid_processing").css("display","none");
          }
        },

        dom: 'lBfrtip',
            buttons: [
                {
                    text: 'Add User',
                    action: function ( e, dt, node, config ) {
                        var url =  '<?php echo base_url();?>add_user';
                        load_page(url);
                    }
                }
            ],  
            
        initComplete: function() {
            $('#users-grid_filter input').unbind().bind('keyup', function(e) {
                if(e.keyCode == 13) {
                    dataTable.search(this.value).draw();
                }
            });
        }

      });
    });

    $(document).off('click','.preview_rpt').on('click','.preview_rpt',function(e) {
        e.preventDefault();
        var report_type = $(this).attr('report_type');
        var url =  '<?php echo base_url();?>print_users';
        open('POST', url, {'report_type':report_type,'active':'<?php echo $module;?>'}, '_blank');
    });

    $(document).off('click','.list_actions').on('click','.list_actions',function(e) {
        e.preventDefault();
        var module = $(this).attr('module');
        var action = $(this).attr('action');
        var ref = $(this).attr('idx');
        var code = $(this).attr('code');
         
        if (action == 'update') {
            var url =  '<?php echo base_url();?>edit_user';     
            load_page(url,{id:ref,code:code})
        } else if (action == 'deactivate') {
            deactivate_user(ref);
        } else if (action == 'activate') {
            activate_user(ref);
        } else if (action == 'view') {
            var url = '<?php echo base_url();?>view_user';     
            load_page(url,{id:ref,code:code})
        } else if (action == 'user_branch') {
            var url = '<?php echo base_url();?>user_branch';     
            load_page(url,{id:ref,code:code})
        } else if (action == 'audit_trail') {
            url =  '<?php echo base_url();?>user_audit_log';
            open('POST', url, {'code':code}, '_blank');
        } else {
            alert(module+'  '+action+' '+ref);
        }
    });

    $(document).off('change','.select_option').on('change','.select_option',function(e) {
        e.preventDefault();
        $('#users-grid').DataTable().search('').draw();
    });

    function activate_user(id)
    {
        if (confirm('Activate user?')) {
            var url = '<?php echo base_url();?>activate_user';
            $.post(url,{id:id}).done(function(data){
               url = '<?php echo base_url();?>users';
               load_page(url)
            });
        }
    }

    function deactivate_user(id)
    {
        if (confirm('Deactivate user?')) {
            var url = '<?php echo base_url();?>deactivate_user';
            $.post(url,{id:id}).done(function(data){
               url = '<?php echo base_url();?>users';
               load_page(url)
            });
        }
    }

</script>