<?php
    function status($status)
    {
      if ($status=='Draft') return 'class="label label-danger"';
      else if ($status=='Approved') return 'class="label label-info"';
      else if ($status=='Disbursed') return 'class="label label-success"';
      else return 'class="label label-danger"';
    }
?>

<div class="box box-info">
  <div class="box-header with-border">
    <h3 class="box-title">Receipts</h3>

    <div class="box-tools pull-right">
      <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
      </button>
      <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
    </div>
  </div>

  <div class="box-body">
    <div class="table-responsive">
      <table class="table no-margin">
        <thead>
        <tr>
          <th>#</th>
          <th>Till</th>
          <th>Customer</th>
          <th>Telephone</th>
          <th>Date</th>
          <th>Amount</th>
        </tr>
        </thead>
        <tbody>
          <?php $i=1;foreach ($receipts as $r) { ?>
            <tr>
              <td><a href="#" class="search_receipt" code="<?=$r->BusinessShortCode;?>" idx="<?=$r->id;?>" tran="receipt"><?=$i++?></a></td>
              <td><?=$r->BusinessShortCode;?></td>
              <td><?=$r->First_Name;?></td>
              <td><?=$r->MSISDN;?></td>
              <td><?=DateTime::createFromFormat('Ymd',substr($r->TransTime,0,8))->format('d/m/Y').' '.substr($r->TransTime,8,2).':'.substr($r->TransTime,10,2).':'.substr($r->TransTime,12,2);?></td>
              <td><?=number_format($r->TransAmount);?></td>
            </tr>
          <?php } ?>
        </tbody>
      </table>
    </div>
  </div>
  <div class="box-footer clearfix">
    <a href="javascript:void(0)" class="btn btn-sm btn-default btn-flat pull-right" id="all_today_receipts">View All Today Receipts</a>
  </div>
</div>

<script type="text/javascript">

    $(function() {
      $("#new_staff").off('click').on('click',function(e){
          //load_page("<?=base_url();?>staff_new");
      });
      $("#leaves").off('click').on('click',function(e){
          //load_page("<?=base_url();?>staff_leaves");
      });
  });

</script>

