<?php
      function date_f($date) {
          return date('d/m/y',strtotime($date));
      }
?>

<div class="box box-info">
  <div class="box-header with-border">
    <h3 class="box-title">Transfers</h3>

    <div class="box-tools pull-right">
      <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
      </button>
      <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
    </div>
  </div>

  <div class="box-body">
    <div class="table-responsive">
      <table class="table no-margin">
        <thead>
        <tr>
          <th>#</th>
          <th>Till</th>
          <th>Customer</th>
          <th>Date</th>
          <th>Amount</th>
        </tr>
        </thead>
        <tbody>
          <?php $i=1;foreach ($transfers as $t) { ?>
            <tr>
              <td><a href="#" class="search_transfer" code="<?=$t->BusinessShortCode;?>" idx="<?=$t->id;?>" tran="transfer"><?=$i++?></a></td>
              <td><?=$t->BusinessShortCode;?></td>
              <td><?=$t->First_Name;?></td>
              <td><?=DateTime::createFromFormat('Ymd',substr($t->TransTime,0,8))->format('d/m/Y').' '.substr($t->TransTime,8,2).':'.substr($t->TransTime,10,2).':'.substr($t->TransTime,12,2);?></td>
              <td><?=number_format($t->TransAmount);?></td>
            </tr>
          <?php } ?>
        </tbody>
      </table>
    </div>
  </div>
  <div class="box-footer clearfix">
    <a href="javascript:void(0)" class="btn btn-sm btn-default btn-flat pull-right" id="all_today_transfers">View All Today Transfers</a>
  </div>
</div>


<script type="text/javascript">
    $(function() {
      $("#new_leave").off('click').on('click',function(e){
          //load_page("<?php echo base_url();?>/leave_add");
      });
      $("#leaves").off('click').on('click',function(e){
          //load_page("<?php echo base_url();?>/leaves_approved");
      });
  });
</script>