<?php 
    $dfrom = date('d-m-Y', strtotime('-0 month')); 
    $dto = date('d-m-Y'); 
?>

<section class="content-header">
    <h1>Transfers{<?=$tillnumber;?>}
    <a style="padding-left:10px;" href="#" class="preview_rpt" id="export_rpt" report_type="PREVIEW" module="<?=$module;?>"><i class="fa fa-print"></i></a>
    <a style="padding-left:15px;" href="#" class="preview_rpt" id="export_excel" report_type="EXCEL" module="<?=$module;?>"><i class="fa fa-file-excel-o"></i></a>
    <a style="padding-left:15px;" href="#" class="preview_rpt" id="export_pdf" report_type="PDF" module="<?=$module;?>"><i class="fa fa-file-pdf-o"></i> </a>
    <small>
        <span style="padding-left:15px;">
            Till Numbers
            <select name="tillnumber" id="tillnumber" font-size="6px" class="select_option">
                <option value="ALL">ALL</option>        
                <?php foreach ($tillnumbers as $t) { ?>
                    <option value="<?=$t->code;?>" <?=$tillnumber==$t->code?"selected":"";?>><?=$t->code;?></option>
                <?php } ?>
            </select>
        </span>
        <span style="padding-left:15px;">
            From
            <input type="text" class="datepicker select_option date_range" name="dfrom" id="dfrom" size="6" value="<?php echo $dfrom;?>" style="font-size:10pt"/>
        </span>
        <span style="padding-left:15px;">
            To
            <input type="text" class="datepicker select_option date_range" name="dto" id="dto" size="6" value="<?php echo $dto;?>" style="font-size:10pt"/>
        </span>
    </small>
    </h1>
</section>

<section class="content">
        <div class="box box-info">
            <div class="box-body">
                <div class="col-sm-12 table-responsive">
                    <div id="view-transfers_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">

                        <table id="transfers-grid"  
                            cellpadding="0" 
                            cellspacing="0" 
                            border="0" 
                            class="display w3-table w3-striped w3-bordered w3-border w3-hoverable w3-white" 
                            width="100%"
                          >
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Code</th>
                                    <th>Till</th>
                                    <th>Name</th>
                                    <th>Phone</th>
                                    <th>Amount</th>
                                    <th>Date</th> 
                                    <th>Time</th>
                                    <th>Balance</th>
                                    <!-- <th>Actions</th>   -->            
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>Code</th>
                                    <th>Till</th>
                                    <th>Name</th>
                                    <th>Phone</th>
                                    <th><div id="total" style="color:red"></div></th>
                                    <th>Date</th> 
                                    <th>Time</th>
                                    <th>Balance</th>
                                    <!-- <th>Actions</th> -->              
                                </tr>
                            </tfoot>

                          <tbody>
                          </tbody>
                      </table>
                    </div>
                </div>
            </div>
        </div>

</section> 

 <script type="text/javascript" language="javascript" >
    $(function() {
      $(".datepicker").datepicker({autoclose:true,format:'dd-mm-yyyy'});

      var dataTable = $('#transfers-grid')
      .on('xhr.dt', function ( e, settings, json, xhr ) {
            $('#total').html(json.total);
        })
      .DataTable( {
        "processing": true,
        "serverSide": true,
        "ajax":{
          url :"<?=base_url();?>transfers_list",
          type: "post", 
            data : function(data) {
                data.module  = '<?=$module;?>';
                data.dfrom  = $('#dfrom').val();
                data.dto  = $('#dto').val();
                data.tillnumber  = $('#tillnumber').val();
            },
          error: function(xhr,status,error){
            alert(xhr.responseText);
            $(".transfers-grid-error").html("");
            $("#transfers-grid").append('<tbody class="transfers-grid-error"><tr><th colspan="3">No data found in the server</th></tr></tbody>');
            $("#transfers-grid_processing").css("display","none");
          }
        },
        initComplete: function() {
            $('#transfers-grid_filter input').unbind().bind('keyup', function(e) {
                if(e.keyCode == 13) {
                    dataTable.search(this.value).draw();
                }
            });
        }
      });
    }); 

    $(document).off('click','.preview_rpt').on('click','.preview_rpt',function(e) {
        e.preventDefault();
        let report_type = $(this).attr('report_type');
        let date_from = $("#dfrom").val();
        let date_to = $("#dto").val();
        let tillnumber = $("#tillnumber").val();

        let url =  '<?=base_url();?>print_transfers';
        open('POST', url, {report_type,'active':'<?=$module;?>',date_from,date_to,tillnumber}, '_blank');
    });

    $(document).off('click','.list_actions').on('click','.list_actions',function(e) {
        e.preventDefault();
        var module = $(this).attr('module');
        var action = $(this).attr('action');
        var ref = $(this).attr('idx');

        if (action == 'statement') {
            var url =  '<?=base_url();?>client_statement';
            open('POST', url,{'id':ref,'code':code},'_blank');
        } else {
            alert(module+'  '+action+' '+ref);
        }
    });

    $(document).off('change','.select_option').on('change','.select_option',function(e) {
        e.preventDefault();
        $('#transfers-grid').DataTable().search('').draw();
    });

</script>