<?php

class Daraja_Model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function get_timestamp()
	{
		return date("YmdHis");
	} 
      
	public function base_64_($key,$secret)
	{ 
		return base64_encode($key.':'.$secret);
	}
    
    public function register_url_($shortcode,$key,$secret)
    {
	    $url = 'https://api.safaricom.co.ke/mpesa/c2b/v1/registerurl';
 
	    $confirmation_url = 'https://www.frontierkenyacredit.com/apps/receipts/confirmation';
		$validation_url = 'https://www.frontierkenyacredit.com/apps/receipts/validation';
 
	    $token = $this->token_($key,$secret);
	    
	    $data = array(
			'ShortCode' => $shortcode,
			'ResponseType' => 'Cancelled',
			'ConfirmationURL' => $confirmation_url,
			'ValidationURL' => $validation_url,
		);
		
	    $data_string = json_encode($data);
        $curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json','Authorization:Bearer '.$token)); 
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

		$curl_response = curl_exec($curl);

		return $curl_response;
    }

    public function register_url()
    {
	    $url = 'https://api.safaricom.co.ke/mpesa/c2b/v1/registerurl';
 
	    $shortcode = '532356'; # STORE
	    $till = '532356'; # TILL
	     
	    $confirmation_url = 'https://www.goldveinsolutions.net/integrations/receipts/payments/confirmation';
		$validation_url = 'https://www.goldveinsolutions.net/integrations/receipts/payments/validation';

	    $token = $this->token('c2b');
	    
	    $data = array(
			'ShortCode' => $shortcode,
			'ResponseType' => 'Cancelled',
			'ConfirmationURL' => $confirmation_url,
			'ValidationURL' => $validation_url,
		);
		
	    $data_string = json_encode($data);
        $curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json','Authorization:Bearer '.$token)); 
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

		$curl_response = curl_exec($curl);

		return $curl_response;
    }
    
	public function base_64($b2c='b2c')
	{ 
	    /* Zion Pork Place */
		if ($b2c=='b2c') {
			$key = 'kEzFF6cGzfW02WaNavSDtKoREJCfXbZP';
			$secret = '78A6sMVaCiQxFGg7';
		} else if ($b2c=='c2b') {
			$key = 'kEzFF6cGzfW02WaNavSDtKoREJCfXbZP';
			$secret = '78A6sMVaCiQxFGg7';
		} else {
			$key = 'kEzFF6cGzfW02WaNavSDtKoREJCfXbZP';
			$secret = '78A6sMVaCiQxFGg7';
		}
		
		$base64 = base64_encode($key.':'.$secret);

		return $base64;
	}
	
	public function token($b2c='c2b')
	{
		$url = 'https://api.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials';

		$base64 = $this->base_64($b2c);

		$request_headers = array();
		$request_headers[] = 'Authorization: Basic ' . $base64;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 60);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$data = curl_exec($ch);
        
        if (curl_errno($ch))
		{
			$token = '';
		}
		else
		{
			$transaction = json_decode($data, TRUE);
			$token = $transaction['access_token'];			
		}
		
		return $token;
	}

	public function token_($key,$secret)
	{
		$url = 'https://api.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials';

		$base64 = $this->base_64_($key,$secret);

		$request_headers = array();
		$request_headers[] = 'Authorization: Basic ' . $base64;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 60);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		$data = curl_exec($ch);
        
        if (curl_errno($ch))
		{
			$token = '';
		}
		else
		{
			$transaction = json_decode($data, TRUE);
			$token = $transaction['access_token'];			
		}
		
		return $token;
	}

	public function stk_push($payer="",$ref="",$amount="",$trandesc="")
	{

	    $passkey = '7e1812b0d792cd3b9e11e36a5c961f3d3807923fc56d05a335f5d70c9e4ec316'; # STORE
	    
	    $url = 'https://api.safaricom.co.ke/mpesa/stkpush/v1/processrequest';

	    $shortcode = '527721'; # HO
	    $shortcode = '527721'; # STORE
		$till = "527721"; # TILL
		
		$callback_url = 'https://honey.co.ke/kiumbe/chnkubu/daraja/validate_stk_push';
		$trantype = "CustomerPayBillOnline";
		$trantype = "CustomerBuyGoodsOnline";
			
		$token = $this->token('c2b');
		$tm = $this->get_timestamp();

		$pass = $shortcode.$passkey.$tm;
		
		$pass = base64_encode($pass);

		$data = array(
			'BusinessShortCode' => $shortcode,
			'Password' => $pass,
			'Timestamp' => $tm,
			'TransactionType' => $trantype,
			'Amount' => $amount,
			'PartyA' => $payer,
			'PartyB' => $till,
			'PhoneNumber' => $payer,
			'CallBackURL' => $callback_url,
			'AccountReference' => $ref,
			'TransactionDesc' => $trandesc
		);

		$data_string = json_encode($data);
        $curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json','Authorization:Bearer '.$token)); 
	    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

		$curl_response = curl_exec($curl);

		$msg = 'Payment request sent to ZION PORK PLACE. Please await response from MPESA to key in PIN to complete transaction.';
		
        return $msg;
	}
	
	public function b2c($payee,$amount,$ref,$remarks)
	{
	    $url = 'https://api.safaricom.co.ke/mpesa/b2c/v1/paymentrequest';

        $initiator = 'EPIC SAVANNAB2C';
	    //$command = 'BusinessPayment';
	    //$command = "PromotionPayment";
	    $command = "SalaryPayment";
	    $shortcode = '855650';
	    $timeout_url = 'https://honey.co.ke/kiumbe/chnkubu/payments/validate_repayment';
		$callback_url = 'ttps://honey.co.ke/kiumbe/chnkubu/payments/validate_repayment';
		$occassion = 'Please pay on time to avoid default';
		
	    $pass = $this->encryt();
		$token = $this->token('b2c');
	    
	    $data = array(
			'InitiatorName' => $initiator,
			'SecurityCredential' => $pass,
			'CommandID' => $command,
			'Amount' => $amount,
			'PartyA' => $shortcode,
			'PartyB' => $payee,
			'Remarks' => $remarks,
			'QueueTimeOutURL' => $timeout_url,
			'ResultURL' => $callback_url,
			'Occassion' => $occassion
		);
		
	    $data_string = json_encode($data);
        $curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json','Authorization:Bearer '.$token)); 
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

		$curl_response = curl_exec($curl);

		return $curl_response;
	}
	
	public function b2b()
	{
	    $url = 'https://api.safaricom.co.ke/mpesa/b2b/v1/paymentrequest';

        $initiator = 'EPIC SAVANNAB2C';
	    $command = 'BusinessPayBill';
	    $PartyA = '823283';
	    $PartyB = '823283';
		$amount = '100';
	    $ref = 'Honey Payment';
	    $timeout_url = 'https://honey.co.ke/kiumbe/chnkubu/payments/validate_repayment';
		$callback_url = 'ttps://honey.co.ke/kiumbe/chnkubu/payments/validate_repayment';
		$remarks = 'Honey Payment';
		$occassion = 'Please pay on time to avoid default';
		
	    $pass = $this->encryt();
		$token = $this->token('b2b');
	    
	    $data = array(
			'Initiator' => $initiator,
			'SecurityCredential' => $pass,
			'CommandID' => $command,
			'SenderIdentifierType' => "4",
			'RecieverIdentifierType' => "4",
			'Amount' => $amount,
			'PartyA' => $PartyA,
			'PartyB' => $PartyB,
			'AccountReference' => $ref,
			'Remarks' => $remarks,
			'QueueTimeOutURL' => $timeout_url,
			'ResultURL' => $callback_url
		);
		
	    $data_string = json_encode($data);
	    
        $curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json','Authorization:Bearer '.$token)); 
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data_string);

	    echo 'Content-Type:application/json','Authorization:Bearer '.$token;
        echo '<br>';
	    echo $data_string;

		$curl_response = curl_exec($curl);

		return $curl_response;
	}
	
	public function encryt()
	{
        $plaintext = "KKWP@2020#";
        
        $fp = fopen("/home/honeycok/public_html/apps/keys/pk_cert.pem","r");
        
        $pub_key = fread($fp,8192);
        fclose($fp);
        
        openssl_get_publickey($pub_key);
        openssl_public_encrypt($plaintext,$crypttext,$pub_key);
        
        $c = base64_encode($crypttext);
        
        return $c;
	}
	
	public function validate_stk_push() 
	{
	    try
        {
            header("Content-Type:application/json");
            $resp = '{"ResultCode":0,"ResultDesc":"Validation passed successfully"}';
            $postData = file_get_contents('php://input');
            $filePath = "/home/savannag/public_html/apps/logs/validate_client_stk.txt";
            $errorLog = "/home/savannag/public_html/apps/logs/errors_stk.txt";
            $file = fopen($filePath,"a");
            fwrite($file, $postData);
            fwrite($file,"\r\n");
        	fwrite($file,$resp);
        	fclose($file);
            
            $this->log_mpesa_stk_push($postData);
            
        } catch (Exception $ex) {
            $logErr = fopen($errorLog,"a");
            fwrite($logErr, $ex->getMessage());
            fwrite($logErr,"\r\n");
            fclose($logErr);
            $resp = '{"ResultCode": 1, "ResultDesc":"Validation failure due to internal service error"}';
        }
        
        return $resp;
    }
    
    public function log_mpesa_stk_push($request)
    {
        $request = json_decode($request);
        $request = $request->Body->stkCallback;
        
        $MerchantRequestID = $request->MerchantRequestID;
        $CheckoutRequestID = $request->CheckoutRequestID;
        $ResultCode = $request->ResultCode;
        $ResultDesc = $request->ResultDesc;
        $CallbackMetadata = $request->CallbackMetadata->Item;
        
        foreach ($CallbackMetadata as $c) {
            if (isset($c->Value)) {
                $key = $c->Name;
                $value = $c->Value;
                if ($key == 'Amount') {$Amount = $value;}
                if ($key == 'MpesaReceiptNumber') {$MpesaReceiptNumber = $value;}
                if ($key == 'TransactionDate') {$TransactionDate = $value;}
                if ($key == 'PhoneNumber') {$PhoneNumber = $value;}
            }
        }   
        
        $this->purchase_payment($PhoneNumber,$Amount,$MpesaReceiptNumber);
        
    }
    
    function purchase_payment($PhoneNumber,$Amount,$MpesaReceiptNumber)
    {
        return '';
    }
	
    public function log_mpesa_c2b($array)
    {
        $transactiontype= mysqli_real_escape_string($con,$array['TransactionType']); 
        $transid=mysqli_real_escape_string($con,$array['TransID']); 
        $transtime= mysqli_real_escape_string($con,$array['TransTime']); 
        $transamount= mysqli_real_escape_string($con,$array['TransAmount']); 
        $businessshortcode=  mysqli_real_escape_string($con,$array['BusinessShortCode']); 
        $billrefno=  mysqli_real_escape_string($con,$array['BillRefNumber']); 
        $invoiceno=  mysqli_real_escape_string($con,$array['InvoiceNumber']); 
        $msisdn=  mysqli_real_escape_string($con,$array['MSISDN']); 
        $orgaccountbalance=   mysqli_real_escape_string($con,$array['OrgAccountBalance']); 
        $firstname=mysqli_real_escape_string($con,$array['FirstName']); 
        $middlename=mysqli_real_escape_string($con,$array['MiddleName']); 
        $lastname=mysqli_real_escape_string($con,$array['LastName']); 
        
        $sql="INSERT INTO mpesa_payments
        ( 
            TransactionType,
            TransID,
            TransTime,
            TransAmount,
            BusinessShortCode,
            BillRefNumber,
            InvoiceNumber,
            MSISDN,
            First_Name,
            Middle_Name,
            Last_Name,
            OrgAccountBalance
        )  
        VALUES  
        ( 
            '$transactiontype', 
            '$transid', 
            '$transtime', 
            '$transamount', 
            '$businessshortcode', 
            '$billrefno', 
            '$invoiceno', 
            '$msisdn',
            '$firstname', 
            '$middlename', 
            '$lastname', 
            '$orgaccountbalance' 
        )";
        
    }
    
}