<?php   
    if (!function_exists('amount')) {
        function amount($d) {
            //return '<input type="text" name="amount" id="amount" idx="'.$d->id.'" value="'.$d->amount.'" val="'.$d->amount.'" class="amount"/>';
            return '<span class="amountzz" idx="'.$d->id.'">'.$d->amount.'</span><span style="float:right;"><i class="fas fa-edit fa-sm amountz" style="align:right" name="amountz" idx="'.$d->id.'" val="'.$d->amount.'"></i></span>';
        }
    }

    if (!function_exists('amountt')) {
        function amountt() {
            return '<input type="text" name="new_amount" id="new_amount" idx="0" value="0"/>';
        }
    }

    if (!function_exists('name')) {
        function name() {
            return '<input type="text" name="new_name" id="new_name" idx="" value=""/>';
        }
    }

    if (!function_exists('phone')) {
        function phone() {
            return '<input type="text" name="new_phone" id="new_phone" idx="0" value=""/>';
        }
    }

    if (!function_exists('save')) {
        function save($d) {
            return '<button type="submit" name="btn_save" id="btn_save" class="save" idx="'.$d->id.'">Save</button>';
        }
    }

    if (!function_exists('add')) {
        function add() {
            return '<button type="submit" name="btn_new" id="btn_new" class="add" idx="0">New Customer</button>';
        }
    }

    if (!function_exists('delete')) {
        function delete($d) {
            return '<button type="submit" name="btn_delete" id="btn_delete" class="delete" idx="'.$d->id.'">Delete</button>';
        }
    }

    if (!function_exists('sms')) {
        function sms($d) {
            return '<button type="submit" name="btn_sms" id="btn_sms" class="sms" idx="'.$d->id.'">Send Reminder</button>';
        }
    }

    if (!function_exists('pay')) {
        function pay($d) {
            return '<button type="submit" name="btn_pay" id="btn_pay" class="pay" idx="'.$d->id.'">Instant MPESA Payment</button>';
        }
    }

    if (!function_exists('namez')) {
        function namez($d) {
            return '<span class="namezz" idx="'.$d->id.'">'.$d->name.'</span><span style="float:right;"><i class="fas fa-edit fa-sm namez" style="align:right" name="namez" idx="'.$d->id.'" val="'.$d->name.'"></i></span>';
        }
    }

    if (!function_exists('phonez')) {
        function phonez($d) {
            return '<span class="phonezz" idx="'.$d->id.'">'.$d->phone.'</span><span style="float:right;"><i class="fas fa-edit fa-sm phonez" style="align:right" name="phonez" idx="'.$d->id.'" val="'.$d->phone.'"></i></span>';
        }
    }

?>

<!DOCTYPE html>
<html>
    <head>
        <style>
        
        #customers {
          font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
          border-collapse: collapse;
          width: 100%;
        }
        
        #customers td, #customers th {
          border: 1px solid #ddd;
          padding: 8px;
        }
        
        #customers tr:nth-child(even){background-color: #f2f2f2;}
        
        #customers tr:hover {background-color: #ddd;}
        
        #customers th {
          padding-top: 12px;
          padding-bottom: 12px;
          text-align: left;
          background-color: #4CAF50;
          color: white;
        }
        
        
        #customers_f {
          font-family: "Trebuchet MS", Arial, Helvetica, sans-serif;
          border-collapse: collapse;
          width: 100%;
        }
        
        #customers_f td, #customers_f th {
          border: 1px solid #ddd;
          padding: 8px;
        }
        
        #customers_f tr:nth-child(even){background-color: #f2f2f2;}
        
        #customers_f tr:hover {background-color: #ddd;}
        
        #customers_f th {
          padding-top: 12px;
          padding-bottom: 12px;
          text-align: left;
          background-color: #4CAF50;
          color: white;
        }
        
        </style>
        <script src="https://kit.fontawesome.com/c899f8aa26.js" crossorigin="anonymous"></script>
    </head>
    <body>
        
        <table id="customers">
          <tr>
            <th>Name</th>
            <th>Telephone</th>
            <th>Amount</th>
            <th>SMS</th>
            <th>Pay</th>
            <th>Delete</th>
          </tr>
            <tbody>
              <?php foreach($debts as $d) { ?>
              <tr id="<?php echo $d->id;?>">
                <td><?php echo namez($d);?></td>
                <td><?php echo phonez($d);?></td>
                <td><?php echo amount($d);?></td>
                <td><?php echo sms($d);?></td>
                <td><?php echo pay($d);?></td>
                <td><?php echo delete($d);?></td>
              </tr>
              <?php } ?>
            </tbody>
          <tr>
        </table>
        <table  id="customers_f"><tbody>
          <tr>
            <td><?php echo name();?></td>
            <td><?php echo phone();?></td>
            <td><?php echo amountt();?></td>
            <td><?php echo add();?></td>
            <td></td>
          </tr>
        </table>
        <input type="hidden" name="unit" id="unit" value="<?php echo $unit;?>"/>
    </body>
    
    <script src="https://code.jquery.com/jquery-3.5.0.min.js" integrity="sha256-xNzN2a4ltkB44Mc/Jz3pT4iU1cmeR0FkXs4pru/JxaQ=" crossorigin="anonymous"></script>
	<script>
        $(function(){
            
            $(document).off("click",".phonez").on('click',".phonez",function(e){
               e.preventDefault();
               
               var id = $(this).attr('idx');
               var phone = $(this).attr('val');
               
               var new_phone = get_phone(id,phone);
               if (phone === new_phone) {} 
               else {
                   $(".phonezz[idx="+id+"]").html(new_phone);
                   $(this).attr('val',new_phone);
                   post(id,new_phone,'phone');
               }
            });  
            
            $(document).off("click",".namez").on('click',".namez",function(e){
               e.preventDefault();
               
               var id = $(this).attr('idx');
               var name = $(this).attr('val');
               
               var new_name = get_name(id,name);
               if (name === new_name) {} 
               else {
                   $(".namezz[idx="+id+"]").html(new_name);
                   $(this).attr('val',new_name);
                   post(id,new_name,'name');
               }
            }); 

            $(document).off("click",".amountz").on('click',".amountz",function(e){
               e.preventDefault();
               
               var id = $(this).attr('idx');
               var amount = $(this).attr('val');
               
               var new_amount = get_amount(id,amount);
               if (amount === new_amount) {} 
               else {
                   $(".amountzz[idx="+id+"]").html(new_amount);
                   $(this).attr('val',new_amount);
                   post(id,new_amount,'amount');
               }
            }); 

            $(document).off("focusout",".amount").on('focusout',".amount",function(e){
               e.preventDefault();
               
               var id = $(this).attr('idx');
               var amount = $(this).attr('val').trim();
               var new_amount = $(this).val().trim();
               if (amount === new_amount) {} 
               else {
                   $(this).attr('val',new_amount);
                   post(id,new_amount,'amount');
               }
            }); 

            $(document).off("click","#btn_new").on('click',"#btn_new",function(e){
               e.preventDefault();
               
               var name = $("#new_name").val().trim();
               var phone = $("#new_phone").val().replace(/\s/g,'');
               var amount = $("#new_amount").val().trim();
               var unit = $("#unit").val().trim();
               
               if (name.trim().length<2) {
                   alert('Name required!');
                   $("#new_name").focus();
               } else if (phone.trim().length<10) {
                   alert('Valid phone required!');
                   $("#new_phone").focus();
               } else if (amount.trim().length<1) {
                   alert('Valid amount required!');
                   $("#new_amount").focus();
               } else {
                   if(confirm('Add new debtor?')) {
                      new_debtor(name,phone,amount,unit);   
                   }
               }
            }); 

            $(document).off("click",".delete").on('click',".delete",function(e){
                e.preventDefault();
               
               var id = $(this).attr('idx');
               deletee(id);
            }); 

            $(document).off("click",".sms").on('click',".sms",function(e){
               e.preventDefault();
               
               var id = $(this).attr('idx');
               sms(id);
            }); 
            
            $(document).off("click",".pay").on('click',".pay",function(e){
               e.preventDefault();
               
               var id = $(this).attr('idx');
               pay(id);
            }); 

            function new_debtor(name,phone,amount,unit) {
                $.post("debts/new_debtor",{name:name,phone:phone,amount:amount,unit:unit}, function(data) {
                    $('#customers > tbody:last-child').append(data);
                    clear_inputs();
                }); 
            }
            
            function clear_inputs() {
                $("#new_name").val('');
                $("#new_phone").val('');
                $("#new_amount").val('');
            }
            
            function post(id,val,typ) {
                $.post("debts/update",{id:id,typ:typ,val:val}, function(data) {}); 
            }
            
            function sms(id) {
                $.post("debts/sms",{id:id}, function(data) {
                    alert('SMS has been sent.');
                }); 
            }
            
            function pay(id) {
                $.post("debts/pay",{id:id}, function(data) {
                    alert('Payment Request has been sent.');
                }); 
            }

            function deletee(id) {
                $('#'+id).remove();
                $.post("debts/delete",{id:id}, function(data) {}); 
            }

        });
        
        function get_name(id,name) {
          var new_name = prompt("Please enter debtor name",name);
          if (new_name != null) {
            return new_name.toUpperCase();
          } else {
              return name;
          }
        }
        
        function get_amount(id,amount) {
          var new_amount = prompt("Please enter amount",amount);
          if (new_amount != null) {
            return new_amount.toUpperCase();
          } else {
              return amount;
          }
        }

        function get_phone(id,phone) {
          var new_phone = prompt("Please enter debtor phone",phone);
          if (new_phone != null) {
            return new_phone.replace(/\s/g,'');
          } else {
              return phone;
          }
        }

    </script>
</html>
